% This script has the complete workflow for the manuscript.
% Required software: MATLAB (version earlier than 2018a), AMICI, PESTO.

clear all
close all
clc

% add folder 'HistoneMethylation' to path
folder = fileparts(which('main_manuscript.m')); 
addpath(genpath(folder));

compileFlag = true; % if simulation files need to be compiled
saveFigures = false;  % if figures should be saved in folder ./figures
doFitting = false; % if fittings should be performed (if false, the result
% files need to exist already,

if compileFlag
    compilation_histones
end

load domains
foldername = './results';

set(0,'defaultAxesFontName', 'Arial')
set(0,'defaultTextFontName', 'Arial')
set(0,'defaultAxesLineWidth', 0.5)

%% Find best offset which is added to data and simulation
% Required because we use log-transformations on the data and we have
% measurements at 0

if doFitting
    models = {'globalDemeth','15domains'};
    stroffsets = {'1em8','1em6','1em5','1em4','1em3','1em2','1em1','2em1',...
        '3em1','5em1','8em1','1','11em1','2','3','10'};
    opts_fitting.nStarts = 100;
    for iNames = 1:length(modelnames)
        for iOff = 1:length(stroffsets)
            opts_fitting.modelname = models{iNames};
            opts_fitting.resultsFile = [foldername '/findOffset/' ...
                'results_' opts_fitting.modelname '_CAL311_319_all_WT_offset' ...
                stroffsets{iOff}];
            eval(['opts_fitting.offset = ' strrep(stroffsets{iOff},'m','-')])
            fitting_histones(opts_fitting);
        end
    end
end
visualize_histones_qqPlot(foldername,saveFigures)

%% Fittings with offset = 0.1
% Fit global model including 6 rates for demethylation
if doFitting
    clear opts_fitting
    opts_fitting.modelname = 'globalDemeth';
    fitting_histones(opts_fitting);
    
    % Fit global model with removed K27 demethylation
    clear opts_fitting
    opts_fitting.modelname = 'globalDemeth';
    opts_fitting.resultsFile = [foldername '/results_globalDemeth_noK27demeth'];
    opts_fitting.indRemove = [2,3,4]; % set K27 demethylation parameters to 0
    fitting_histones(opts_fitting);
    
    % Fit domain model with 15 domains (most complex model)
    clear opts_fitting
    opts_fitting.modelname = '15domains';
    fitting_histones(opts_fitting);
end

%% Visualize models
%domainModelFile= [foldername '/findOffset/results_15domains_CAL311_319_all_WT_offset1em1'];
%visualize_histones_fitsForPaper(foldername,domainModelFile)

%% Laplace vs Normal
if doFitting
    clear opts_fitting
    opts_fitting.nStarts = 40;
    opts_fitting.distribution = 'normal';
    opts_fitting.modelname = '15domains';
    opts_fitting.resultsFile = [foldername '/15domains_normal'];
    fitting_histones(opts_fitting);
    
    clear opts_fitting
    opts_fitting.nStarts = 40;
    opts_fitting.distribution = 'normal';
    opts_fitting.resultsFile = [foldername '/globalDemeth_normal'];
    opts_fitting.modelname = 'globalDemeth';
    fitting_histones(opts_fitting);
end

load([foldername '/results_globalDemeth_normal'],'parameters','DA')
n_data = sum(sum(sum(~isnan(DA.my))));
normal_BIC(1) = -2*parameters.MS.logPost(1) + ...
    log(n_data)*(parameters.number+1);

load([foldername '/results_15domains_normal'],'parameters')
normal_BIC(2) = -2*parameters.MS.logPost(1) + ...
    log(n_data)*(parameters.number+1);

load([foldername '/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1'],...
    'parameters')
laplace_BIC(1) = -2*parameters.MS.logPost(1) + ...
    log(n_data)*(parameters.number+1);
load([foldername '/findOffset/results_15domains_CAL311_319_all_WT_offset1em1']...
    ,'parameters')
laplace_BIC(2) = -2*parameters.MS.logPost(1) + ...
    log(n_data)*(parameters.number+1);

disp(['differences in BIC values (normal - Laplace): '])
disp(['global: ' num2str(normal_BIC(1)-laplace_BIC(1))]);
disp(['domain: ' num2str(normal_BIC(2)-laplace_BIC(2))]);

%% Model reduction for domain model
% Example for fitting domain model with domains 00, 23 and 32
if doFitting
    tmp_domains = {'00','23','32'};
    modelname = struct2str(tmp_domains);
    
    % ind = 119;
    % tmp_domains = domains{ind};
    % modelname = modelnames{ind};
    
    % simulation file for preequilibration of generation 1 (= light) histones
    generate_domainModel(tmp_domains,[modelname  '_light_preequ'],{'l_preequ'})
    amiwrap(['histones_' modelname '_light_preequ'],...
        ['histones_' modelname '_light_preequ_syms'],'./simulation/generatedSimulations');
    
    % simulation file for generation 1,2,3 (= light, medium, heavy) histones
    generate_domainModel(tmp_domains,[modelname '_all'],{'l','m','h'})
    amiwrap(['histones_' modelname '_all'],...
        ['histones_' modelname '_all_syms'],'./simulation/generatedSimulations');
    
    opts_fitting.domains = tmp_domains;
    opts_fitting.modelname = modelname;
    fitting_histones(opts_fitting);
end

indDomain = reduce_domainModel(foldername,saveFigures);

%% Find, analyze and visualize best model
baseResultFile = [foldername '/results_' modelnames{indDomain}];
load(baseResultFile);
plotMultiStarts(parameters);
domainModelFile = [foldername '/results_' modelnames{indDomain}];
visualize_histones_fitsForPaper(foldername, domainModelFile, 'reduced', saveFigures)

%% Model predictions for inhibitor experiment
predict_inhibition(domainModelFile,saveFigures);

%% Calculate BIC weights and fluxes for all tested domain models
fh = analyze_domainModelsUntreated(saveFigures);

%% Comparison of untreated and recovery generation 2 histones
% Forward selection
fh = modelSelection_untreated_recovery(indDomain,saveFigures);

%% Visualization
fh = visualize_histones_comparison_untreatedRecovery(indDomain,saveFigures);