function [] = forwardSelection_untr_rec(baseModelFile,checkIndices)
% Fitting routine for forward selection procedure.

load(baseModelFile)
    
simulateA = @(t,xi,kappa,options) ...
    simulate_histones_all_withpreequ(t,xi,kappa,options,sim_light,sim_all);

numDiffsBase = length(options.llh.diffB_theta);
strDiffsBase = '';
for i = 1:numDiffsBase
    strDiffsBase = [strDiffsBase '' num2str(options.llh.diffB_theta{i}) '_'];
end

param_backup = parameters;
clear parameters

for count = checkIndices
    clear parameters
    parameters = param_backup;
    parameters.name{end+1} = ['\\kappa_{' parameters.name{count} '}'];
    parameters.min(end+1) = -6;
    parameters.max(end+1) = 6;
    parameters.number = length(parameters.name);
    
    options.llh.diffB_xiind(numDiffsBase+1) = length(parameters.name);
    options.llh.diffB_theta{numDiffsBase+1} = count;
    
    options.MS.n_starts = 20;
    if ~exist('opts_fitting')
        options.MS.foldername = [baseModelFile '_diff' num2str(count)];
    else
        options.MS.foldername = ['./results/forwSel_' opts_fitting.modelname ...
            '_untr_rec_diff' strDiffsBase '' num2str(count)];
    end
    options.MS.foldername = ['./results/forwSel_' opts_fitting.modelname ...
        '_untr_rec_diff' strDiffsBase '' num2str(count)];
    parameters.guess = [getParameterGuesses(parameters,@(xi) ...
        logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options),...
        options.MS.n_starts, parameters.min, parameters.max,options.MS)];
    parameters = getMultiStarts(parameters,@(xi) ...
        logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options),...
        options.MS);
    parameters.MS.BIC = -2*parameters.MS.logPost+ ...
        log(n_data)*(parameters.number+1);
    save(options.MS.foldername,...
            'parameters','opts_fitting','options','DA','DB','n_data',...
            'sim_light','sim_all','simulateA','simulateB');    
end