function [] = fit_specificDiffModel(indDomain,diff)

foldername = './results';
saveFigures = false;
load domains
strDiffs = ind2str(diff);

baseModelFile = ['./results/results_' modelnames{indDomain} '_untr_rec_no'];
load(baseModelFile)

simulateA = @(t,xi,kappa,options) ...
    simulate_histones_all_withpreequ(t,xi,kappa,options,sim_light,sim_all);

param_backup = parameters;
clear parameters

parameters = param_backup;

for iDiff = 1:length(diff)
    parameters.name{end+1} = ['\\kappa_{' parameters.name{diff(iDiff)} '}'];
    parameters.min(end+1) = -6;
    parameters.max(end+1) = 6;
    parameters.number = length(parameters.name);
    options.llh.diffB_xiind(iDiff) = length(parameters.name);
    options.llh.diffB_theta{iDiff} = diff(iDiff);
end

options.MS.n_starts = 20;
options.MS.foldername = ['./results/forwSel_' opts_fitting.modelname ...
        '_untr_rec_diff' strDiffs];

parameters.guess = [getParameterGuesses(parameters,@(xi) ...
    logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options),...
    options.MS.n_starts, parameters.min, parameters.max,options.MS)];
parameters = getMultiStarts(parameters,@(xi) ...
    logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options),...
    options.MS);
parameters.MS.BIC = -2*parameters.MS.logPost+ ...
    log(n_data)*(parameters.number+1);
save(options.MS.foldername,...
    'parameters','opts_fitting','options','DA','DB','n_data',...
    'sim_light','sim_all','simulateA','simulateB');