function D = importHistoneData(experiment,condition,saveData)
% for the fitting/simulation the time then needs to be shifted + 3
% and the last time points need to be excluded

flag_sameaxis = 0;

%switch experiment
[~, ~, raw] = xlsread(['/Users/carolinloos/Dropbox/Cell memory-Lundbeck-WP1/Data/November2018/Peptide Ratio Results_H3_27-40_' ...
    experiment '_081118_ordered.xlsx'],'Tabelle1');
raw = raw(2:end,:);
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
stringVectors = string(raw(:,[1,2,3,6,7,8,9,11,17,18,20,21,23,27]));
stringVectors(ismissing(stringVectors)) = '';
raw = raw(:,[4,5,10,12,13,14,15,16,19,22,24,25,26,28]);
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN};
data = reshape([raw{:}],size(raw));
ProteinName = (stringVectors(:,2));
ReplicateName = (stringVectors(:,3));
PeptideNote = (stringVectors(:,6));
IsotopeLabelType = (stringVectors(:,8));
Area = data(:,11);
Sample = data(:,9);
Ratios = stringVectors(:,14);
PercRespectiveModification = data(:,14);

%     case {'CAL311-313','CAL317-319'}
%         [~, ~, raw] = xlsread('/Users/carolinloos/PhD/Histones/HistonesCode/data/Peptide Ratio Results_LMHall_H3_27-40_090818_Precursor_MVAvalues.xlsx','Tabelle1');
%         raw = raw(2:end,:);
%         raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
%         stringVectors = string(raw(:,[1,2,3,6,7,8,9,11,17,18,21,23,27]));
%         stringVectors(ismissing(stringVectors)) = '';
%         raw = raw(:,[4,5,10,12,13,14,15,16,19,20,22,24,25,26,28]);
%         R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
%         raw(R) = {NaN};
%         data = reshape([raw{:}],size(raw));
%         % extract important columns
%         ProteinName = stringVectors(:,2);
%         ReplicateName = stringVectors(:,3);
%         PeptideNote = stringVectors(:,6);
%         IsotopeLabelType = stringVectors(:,8);
%         Sample = data(:,9);
%         Ratios = stringVectors(:,13);
%         Area = data(:,12);
%         PercRespectiveModification = data(:,15);
%     case 'CAL314-316'
%         [~, ~, raw] = xlsread('/Users/carolinloos/PhD/Histones/HistonesCode/data/Peptide Ratio Results_H3_27-40_LMHall_lundbeck_MVA_300818_MVAvalues_CAL314-316.xlsx','H3_27-40_CAL314-316');
%         raw = raw(2:end,:);
%         raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
%         stringVectors = string(raw(:,[1,2,3,6,7,8,9,11,17,18,20,21,23,27]));
%         stringVectors(ismissing(stringVectors)) = '';
%         raw = raw(:,[4,5,10,12,13,14,15,16,19,22,24,25,26,28]);
%         R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
%         raw(R) = {NaN}; % Replace non-numeric cells
%         data = reshape([raw{:}],size(raw));
%         % extract important columns
%         ProteinName = (stringVectors(:,2));
%         ReplicateName = (stringVectors(:,3));
%         PeptideNote = (stringVectors(:,6));
%         IsotopeLabelType = (stringVectors(:,8));
%         Sample = data(:,9);
%         Area = data(:,11);
%         Ratios = stringVectors(:,14);
%         PercRespectiveModification = data(:,14);
%end

% Clear temporary variables
clearvars data raw stringVectors R;

%% Generate full table and filter peptide
T_full = table(ProteinName,ReplicateName,PeptideNote,IsotopeLabelType,...
    Sample,Area,Ratios,PercRespectiveModification);
T = T_full(strcmp(T_full.ProteinName,'H3_27-40'),:);

% outlier removal
T.Area(T.Sample==20 & strcmp(T.ReplicateName,'CAL319')) = NaN;

% Modifications that share a peak
T.Area(strcmp(T.PeptideNote,'K36_me1')) = T.Area(strcmp(T.PeptideNote,'K27_me1'));
T.Area(strcmp(T.PeptideNote,'K36_me3')) = T.Area(strcmp(T.PeptideNote,'K27_me2_K36_me1'));

switch experiment
    case 'CAL311-313'
        cals = {'CAL311','CAL312','CAL313'};
        time = [0,4,8,16,24,48,96];
    case 'CAL314-316'
        cals = {'CAL314','CAL315','CAL316'};
        time = [-3,0,4,8,16];
    case 'CAL317-319'
        cals = {'CAL317','CAL318','CAL319'};
        time = [-3,0,4,8,16,24,48];
end

intermediates = unique(IsotopeLabelType);
modifications = unique(PeptideNote);
modifications = modifications([1,13,14,15,2,3,4,5,6,7,8,9,10,11,12]);

D.observable_names = modifications;

if strcmp(experiment,'CAL317-319')
    colors = [134,189,74;
        127,47,123;
        180,180,180]./255;
else
    colors = [134,189,74;
        180,180,180;
        127,47,123]./255;
end
ind_intermediate = [3,2,1];
close all
for i = 1:numel(ind_intermediate)
    fh{i}=figure('name',intermediates{ind_intermediate(i)});
end
for c = 1:3 % replicate
    vals = zeros(14,numel(ind_intermediate),15);
    for m = 1:15 % modification
        tmpT = T(strcmp(T.ReplicateName,cals(c)) & ...
            strcmp(T.PeptideNote,modifications(m)),:);
        samples = unique(tmpT.Sample);
        switch experiment
            case {'CAL311-313','CAL317-319'}
                switch condition
                    case 'WT'
                        samples = samples(1:7);
                    case 'Inh'
                        samples = samples(8:end);
                end
            case 'CAL314-316'
                switch condition
                    case 'WT'
                        samples = samples([1,2:5]);
                    case 'Inh'
                        samples = samples([1,6:9]);
                end
        end
        for s = 1:length(samples)
            tmpT_s = tmpT(tmpT.Sample==samples(s),:);
            for i = 1:numel(ind_intermediate)
                ind = find(strcmp(tmpT_s.IsotopeLabelType,...
                    intermediates{ind_intermediate(i)}));
                if ~isempty(ind)
                    switch intermediates(ind_intermediate(i))
                        case 'light'
                            label = 'light';
                        case 'full medium (R6K4)'
                            label = 'full medium';
                        case 'full heavy (R10K8)'
                            label = 'full heavy';
                    end
                    ratio = tmpT_s.Ratios(ind);
                    ratio = str2double(ratio{1});
                    switch modifications(m)
                        case 'K27_me1'
                            vals(s,i,m) = ratio/(ratio+1)*tmpT_s.Area(ind);
                            %factors(s,i,m) = ratio/(ratio+1);
                        case 'K36_me1'
                            vals(s,i,m) = 1/(ratio+1)*tmpT_s.Area(ind);
                            %factors(s,i,m) = 1/(ratio+1);
                        case 'K27_me2_K36_me1'
                            vals(s,i,m) = ratio/(ratio+1)*tmpT_s.Area(ind);
                            %factors(s,i,m) = ratio/(ratio+1);
                        case 'K36_me3'
                            vals(s,i,m) = 1/(ratio+1)*tmpT_s.Area(ind);
                            %factors(s,i,m) = 1/(ratio+1);
                        otherwise
                            vals(s,i,m) = tmpT_s.Area(ind);
                            %factors(s,i,m) = 1;
                    end
                end
            end
        end
    end
    
    for i = 1:numel(ind_intermediate)
        for s = 1:length(samples)
            vals_plot(s,i,:) = vals(s,i,:)./sum(vals(s,i,:),3);
        end
        figure(fh{i})
        for m = 1:15 % modification
            subplot(4,4,m)
            lh{i}=plot(1:length(samples), vals_plot(1:length(samples),i,m),...
                '-o','MarkerSize',3,'Color',colors(i,:)); hold on;
            title(modifications(m),'interpreter','none');
            set(gca,'xtick',1:length(samples));
            switch experiment
                case 'CAL311-313'
                    set(gca,'xticklabel',{'0','4','8','16','24','48','96'});
                case 'CAL314-316'
                    set(gca,'xticklabel',{'-3','0','4','8','16'});
                case 'CAL317-319'
                    set(gca,'xticklabel',{'-3','0','4','8','16','24','48'});
            end
            xlim([1,length(samples)]);
        end
    end
    D.t = time;
    D.my(:,1:15,c) = squeeze(vals_plot(1:numel(time),1,:)); % light
    if strcmp(experiment,'CAL317-319')
        D.my(:,16:30,c) = squeeze(vals_plot(1:numel(time),3,:)); % medium
        D.my(:,31:45,c) = squeeze(vals_plot(1:numel(time),2,:)); % heavy
    else
        D.my(:,16:30,c) = squeeze(vals_plot(1:numel(time),2,:));
        D.my(:,31:45,c) = squeeze(vals_plot(1:numel(time),3,:));
    end
    D.my(D.t<=0,31:45,:,:) = NaN; % heavy not present before
    D.my(D.t<0,16:30,:,:) = NaN; % medium not present before
    
    D.replicates = cals;
    D.modifications = modifications;
end

for i = 1:numel(ind_intermediate)
    figure(fh{i})
    if flag_sameaxis
        for m = 1:15 % modification
            subplot(4,4,m)
            ylim([0,0.5])
        end
    else
        for m = 1:15 % modification
            s=subplot(4,4,m);
            ylim([0,s.YLim(2);]);
        end
    end
    intermedstr = erase(erase(strrep(strrep(intermediates{ind_intermediate(i)},' ','_'),'/','_'),')'),'(');
    set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 30 15])
%     switch experiment
%         case 'CAL311-313'
%             print('-depsc',['../figures/CAL311312313_' intermedstr '_' condition])
%         case 'CAL314-316'
%             print('-depsc',['../figures/CAL314315316_' intermedstr '_' condition])
%         case 'CAL317-319'
%             print('-depsc',['../figures/CAL317318319_' intermedstr '_' condition])
%     end
end

if saveData
    switch experiment
        case 'CAL311-313'
            save(['CAL311312313_' condition],'D')
        case 'CAL314-316'
            save(['CAL314315316_' condition],'D')
        case 'CAL317-319'
            save(['CAL317318319_' condition],'D')
    end
end

