function fh = analyze_domainModelsUntreated(saveFigures)

foldername = './results';
       
load domains
load([foldername '/results_15domains_CAL311_319_all_WT_offset1em1'],'DA')
n_data = sum(sum(sum(~isnan(DA.my))));
allBICs = nan(length(domains),1);
for ind = 1:length(domains)
    try
        load([foldername '/results_' modelnames{ind}],'parameters')
        allBICs(ind) = -2*parameters.MS.logPost(1) + log(n_data)*(parameters.number+1);
    end
end
% Calculate BIC weights
diffBICs = allBICs-min(allBICs);
BICweights = exp(-0.5*diffBICs)./nansum(exp(-0.5*diffBICs));
computeFluxes = false;
if computeFluxes
    fluxes = nan(22,length(domains));
    for ind = 1:length(domains)
        try
            load([foldername '/results_' modelnames{ind}],'parameters',...
                'options','simulateA');
            fluxes(:,ind) = get_flux_domainModel(parameters,...
                 parameters.MS.par(:,1),options,simulateA,domains{ind});
        end
    end
else
    load fluxes fluxes % precomputed because it requires the compilation of all simulation files
end

[~,indSort] = sort(BICweights);
nModels = sum(~isnan(BICweights));
indSort = indSort(1:nModels);

%% Visualize fluxes
figure
colorsParam = parula(nModels);
for ind = 1:numel(indSort)
    try
        plot(fluxes(end:-1:1,indSort(ind)),1:22,'-o','Color',...
            colorsParam(nModels-ind,:),'MarkerSize',2,'linewidth',1); hold on;
    end
end
ylim([1-0.01,22+0.01]);
ylabel(' ');
xlabel('flux');

flux_weighted = bsxfun(@times,fluxes,BICweights');
flux_avg = nansum(flux_weighted,2);
plot(flux_avg(end:-1:1),1:22,'r-o','MarkerSize',2,'linewidth',0.5); hold on;
        
for i = 1:22
    names{23-i} = strrep(strrep(parameters.name{i},'r',''),'_','->');
end  
set(gca,'ytick',1:22,'yticklabel',names,'FontSize',6)
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-depsc',['./figures/parallelCoordinate_Models_fluxes']);
end

fh = visualize_flux_domainModel(parameters,flux_avg);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 8 8])
if saveFigures
    print('-depsc',['./figures/BICweighted_fluxes']);
end
