
#include "amici/symbolic_functions.h"
#include "amici/defines.h" //realtype definition
typedef amici::realtype realtype;
#include <cmath> 

using namespace amici;

void dydp_model_jakstat_adjoint_o2(double *dydp, const realtype t, const realtype *x, const realtype *p, const realtype *k, const realtype *h, const int ip, const realtype *w, const realtype *dwdp) {
switch (ip) {
  case 4: {
  dydp[0] = -1.0/(p[4]*p[4])*p[13]*(x[1]+x[2]*2.0);
  dydp[1] = -1.0/(p[4]*p[4])*p[12]*(x[0]+x[1]+x[2]*2.0);
  dydp[3] = -1.0/(p[4]*p[4])*p[13]*x[10]-1.0/(p[4]*p[4])*p[13]*x[11]*2.0;
  dydp[4] = -1.0/(p[4]*p[4])*p[12]*x[9]-1.0/(p[4]*p[4])*p[12]*x[10]-1.0/(p[4]*p[4])*p[12]*x[11]*2.0;
  dydp[6] = -1.0/(p[4]*p[4])*p[13]*x[19]-1.0/(p[4]*p[4])*p[13]*x[20]*2.0;
  dydp[7] = -1.0/(p[4]*p[4])*p[12]*x[18]-1.0/(p[4]*p[4])*p[12]*x[19]-1.0/(p[4]*p[4])*p[12]*x[20]*2.0;
  dydp[9] = -1.0/(p[4]*p[4])*p[13]*x[28]-1.0/(p[4]*p[4])*p[13]*x[29]*2.0;
  dydp[10] = -1.0/(p[4]*p[4])*p[12]*x[27]-1.0/(p[4]*p[4])*p[12]*x[28]-1.0/(p[4]*p[4])*p[12]*x[29]*2.0;
  dydp[12] = -1.0/(p[4]*p[4])*p[13]*x[37]-1.0/(p[4]*p[4])*p[13]*x[38]*2.0;
  dydp[13] = -1.0/(p[4]*p[4])*p[12]*x[36]-1.0/(p[4]*p[4])*p[12]*x[37]-1.0/(p[4]*p[4])*p[12]*x[38]*2.0;
  dydp[15] = -1.0/(p[4]*p[4])*p[13]*x[46]-1.0/(p[4]*p[4])*p[13]*x[47]*2.0+1.0/(p[4]*p[4]*p[4])*p[13]*(x[1]+x[2]*2.0)*2.0;
  dydp[16] = -1.0/(p[4]*p[4])*p[12]*x[45]-1.0/(p[4]*p[4])*p[12]*x[46]-1.0/(p[4]*p[4])*p[12]*x[47]*2.0+1.0/(p[4]*p[4]*p[4])*p[12]*(x[0]+x[1]+x[2]*2.0)*2.0;
  dydp[18] = -1.0/(p[4]*p[4])*p[13]*x[55]-1.0/(p[4]*p[4])*p[13]*x[56]*2.0;
  dydp[19] = -1.0/(p[4]*p[4])*p[12]*x[54]-1.0/(p[4]*p[4])*p[12]*x[55]-1.0/(p[4]*p[4])*p[12]*x[56]*2.0;
  dydp[21] = -1.0/(p[4]*p[4])*p[13]*x[64]-1.0/(p[4]*p[4])*p[13]*x[65]*2.0;
  dydp[22] = -1.0/(p[4]*p[4])*p[12]*x[63]-1.0/(p[4]*p[4])*p[12]*x[64]-1.0/(p[4]*p[4])*p[12]*x[65]*2.0;
  dydp[24] = -1.0/(p[4]*p[4])*p[13]*x[73]-1.0/(p[4]*p[4])*p[13]*x[74]*2.0;
  dydp[25] = -1.0/(p[4]*p[4])*p[12]*x[72]-1.0/(p[4]*p[4])*p[12]*x[73]-1.0/(p[4]*p[4])*p[12]*x[74]*2.0;
  dydp[27] = -1.0/(p[4]*p[4])*p[13]*x[82]-1.0/(p[4]*p[4])*p[13]*x[83]*2.0;
  dydp[28] = -1.0/(p[4]*p[4])*p[12]*x[81]-1.0/(p[4]*p[4])*p[12]*x[82]-1.0/(p[4]*p[4])*p[12]*x[83]*2.0;
  dydp[30] = -1.0/(p[4]*p[4])*p[13]*x[91]-1.0/(p[4]*p[4])*p[13]*x[92]*2.0;
  dydp[31] = -1.0/(p[4]*p[4])*p[12]*x[90]-1.0/(p[4]*p[4])*p[12]*x[91]-1.0/(p[4]*p[4])*p[12]*x[92]*2.0;
  dydp[33] = -1.0/(p[4]*p[4])*p[13]*x[100]-1.0/(p[4]*p[4])*p[13]*x[101]*2.0;
  dydp[34] = -1.0/(p[4]*p[4])*p[12]*x[99]-1.0/(p[4]*p[4])*p[12]*x[100]-1.0/(p[4]*p[4])*p[12]*x[101]*2.0;
  dydp[36] = -1.0/(p[4]*p[4])*p[13]*x[109]-1.0/(p[4]*p[4])*p[13]*x[110]*2.0;
  dydp[37] = -1.0/(p[4]*p[4])*p[12]*x[108]-1.0/(p[4]*p[4])*p[12]*x[109]-1.0/(p[4]*p[4])*p[12]*x[110]*2.0;
  dydp[39] = -1.0/(p[4]*p[4])*p[13]*x[118]-1.0/(p[4]*p[4])*p[13]*x[119]*2.0;
  dydp[40] = -1.0/(p[4]*p[4])*(x[0]+x[1]+x[2]*2.0)-1.0/(p[4]*p[4])*p[12]*x[117]-1.0/(p[4]*p[4])*p[12]*x[118]-1.0/(p[4]*p[4])*p[12]*x[119]*2.0;
  dydp[42] = -1.0/(p[4]*p[4])*(x[1]+x[2]*2.0)-1.0/(p[4]*p[4])*p[13]*x[127]-1.0/(p[4]*p[4])*p[13]*x[128]*2.0;
  dydp[43] = -1.0/(p[4]*p[4])*p[12]*x[126]-1.0/(p[4]*p[4])*p[12]*x[127]-1.0/(p[4]*p[4])*p[12]*x[128]*2.0;
  dydp[45] = -1.0/(p[4]*p[4])*p[13]*x[136]-1.0/(p[4]*p[4])*p[13]*x[137]*2.0;
  dydp[46] = -1.0/(p[4]*p[4])*p[12]*x[135]-1.0/(p[4]*p[4])*p[12]*x[136]-1.0/(p[4]*p[4])*p[12]*x[137]*2.0;
  dydp[48] = -1.0/(p[4]*p[4])*p[13]*x[145]-1.0/(p[4]*p[4])*p[13]*x[146]*2.0;
  dydp[49] = -1.0/(p[4]*p[4])*p[12]*x[144]-1.0/(p[4]*p[4])*p[12]*x[145]-1.0/(p[4]*p[4])*p[12]*x[146]*2.0;
  dydp[51] = -1.0/(p[4]*p[4])*p[13]*x[154]-1.0/(p[4]*p[4])*p[13]*x[155]*2.0;
  dydp[52] = -1.0/(p[4]*p[4])*p[12]*x[153]-1.0/(p[4]*p[4])*p[12]*x[154]-1.0/(p[4]*p[4])*p[12]*x[155]*2.0;

  } break;

  case 5: {
  dydp[2] = amici::Dspline_pos(4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[20] = amici::DDspline_pos(4,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[23] = amici::DDspline_pos(6,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[26] = amici::DDspline_pos(8,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[29] = amici::DDspline_pos(10,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[32] = amici::DDspline_pos(12,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);

  } break;

  case 6: {
  dydp[2] = amici::Dspline_pos(6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[20] = amici::DDspline_pos(6,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[23] = amici::DDspline_pos(6,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[26] = amici::DDspline_pos(8,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[29] = amici::DDspline_pos(10,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[32] = amici::DDspline_pos(12,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);

  } break;

  case 7: {
  dydp[2] = amici::Dspline_pos(8,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[20] = amici::DDspline_pos(8,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[23] = amici::DDspline_pos(8,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[26] = amici::DDspline_pos(8,8,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[29] = amici::DDspline_pos(10,8,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[32] = amici::DDspline_pos(12,8,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);

  } break;

  case 8: {
  dydp[2] = amici::Dspline_pos(10,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[20] = amici::DDspline_pos(10,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[23] = amici::DDspline_pos(10,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[26] = amici::DDspline_pos(10,8,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[29] = amici::DDspline_pos(10,10,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[32] = amici::DDspline_pos(12,10,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);

  } break;

  case 9: {
  dydp[2] = amici::Dspline_pos(12,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[20] = amici::DDspline_pos(12,4,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[23] = amici::DDspline_pos(12,6,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[26] = amici::DDspline_pos(12,8,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[29] = amici::DDspline_pos(12,10,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);
  dydp[32] = amici::DDspline_pos(12,12,t,5,0.0,p[5],5.0,p[6],1.0E1,p[7],2.0E1,p[8],6.0E1,p[9],0.0,0.0);

  } break;

  case 10: {
  dydp[1] = 1.0;

  } break;

  case 11: {
  dydp[0] = 1.0;

  } break;

  case 12: {
  dydp[1] = (x[0]+x[1]+x[2]*2.0)/p[4];
  dydp[4] = x[9]/p[4]+x[10]/p[4]+(x[11]*2.0)/p[4];
  dydp[7] = x[18]/p[4]+x[19]/p[4]+(x[20]*2.0)/p[4];
  dydp[10] = x[27]/p[4]+x[28]/p[4]+(x[29]*2.0)/p[4];
  dydp[13] = x[36]/p[4]+x[37]/p[4]+(x[38]*2.0)/p[4];
  dydp[16] = -1.0/(p[4]*p[4])*(x[0]+x[1]+x[2]*2.0)+x[45]/p[4]+x[46]/p[4]+(x[47]*2.0)/p[4];
  dydp[19] = x[54]/p[4]+x[55]/p[4]+(x[56]*2.0)/p[4];
  dydp[22] = x[63]/p[4]+x[64]/p[4]+(x[65]*2.0)/p[4];
  dydp[25] = x[72]/p[4]+x[73]/p[4]+(x[74]*2.0)/p[4];
  dydp[28] = x[81]/p[4]+x[82]/p[4]+(x[83]*2.0)/p[4];
  dydp[31] = x[90]/p[4]+x[91]/p[4]+(x[92]*2.0)/p[4];
  dydp[34] = x[99]/p[4]+x[100]/p[4]+(x[101]*2.0)/p[4];
  dydp[37] = x[108]/p[4]+x[109]/p[4]+(x[110]*2.0)/p[4];
  dydp[40] = x[117]/p[4]+x[118]/p[4]+(x[119]*2.0)/p[4];
  dydp[43] = x[126]/p[4]+x[127]/p[4]+(x[128]*2.0)/p[4];
  dydp[46] = x[135]/p[4]+x[136]/p[4]+(x[137]*2.0)/p[4];
  dydp[49] = x[144]/p[4]+x[145]/p[4]+(x[146]*2.0)/p[4];
  dydp[52] = x[153]/p[4]+x[154]/p[4]+(x[155]*2.0)/p[4];

  } break;

  case 13: {
  dydp[0] = (x[1]+x[2]*2.0)/p[4];
  dydp[3] = x[10]/p[4]+(x[11]*2.0)/p[4];
  dydp[6] = x[19]/p[4]+(x[20]*2.0)/p[4];
  dydp[9] = x[28]/p[4]+(x[29]*2.0)/p[4];
  dydp[12] = x[37]/p[4]+(x[38]*2.0)/p[4];
  dydp[15] = x[46]/p[4]+(x[47]*2.0)/p[4]-1.0/(p[4]*p[4])*(x[1]+x[2]*2.0);
  dydp[18] = x[55]/p[4]+(x[56]*2.0)/p[4];
  dydp[21] = x[64]/p[4]+(x[65]*2.0)/p[4];
  dydp[24] = x[73]/p[4]+(x[74]*2.0)/p[4];
  dydp[27] = x[82]/p[4]+(x[83]*2.0)/p[4];
  dydp[30] = x[91]/p[4]+(x[92]*2.0)/p[4];
  dydp[33] = x[100]/p[4]+(x[101]*2.0)/p[4];
  dydp[36] = x[109]/p[4]+(x[110]*2.0)/p[4];
  dydp[39] = x[118]/p[4]+(x[119]*2.0)/p[4];
  dydp[42] = x[127]/p[4]+(x[128]*2.0)/p[4];
  dydp[45] = x[136]/p[4]+(x[137]*2.0)/p[4];
  dydp[48] = x[145]/p[4]+(x[146]*2.0)/p[4];
  dydp[51] = x[154]/p[4]+(x[155]*2.0)/p[4];

  } break;

}
}

