/***********************************************************************************************//**
 * @author Tanja Munz
 * @file diagramlegend.h
 **************************************************************************************************/
#ifndef DIAGRAMLEGEND_H
#define DIAGRAMLEGEND_H

#include "trial.h"
#include <QWidget>

struct Settings;
class Trial;

/***********************************************************************************************//**
 * Legend showing colors of test conditions.
 **************************************************************************************************/
class DiagramLegend : public QWidget
{

    Q_OBJECT

public:

    /*******************************************************************************************//**
     * Constructor.
     **********************************************************************************************/
    DiagramLegend(Settings* settings);

    /*******************************************************************************************//**
     * Changes size before showing the widget.
     **********************************************************************************************/
    void show();

protected:

    /*******************************************************************************************//**
     * Paint event.
     **********************************************************************************************/
    void paintEvent(QPaintEvent*);

protected:

    /// Contains settings for the plot.
    Settings* m_settings;

};

#endif // DIAGRAMLEGEND_H
