/***********************************************************************************************//**
 * @author Tanja Munz
 * @file keypressfilter.h
 **************************************************************************************************/
#ifndef KEYPRESSFILTER_H
#define KEYPRESSFILTER_H

#include <QEvent>
#include <QObject>

/***********************************************************************************************//**
 * This class handles key press events.
 **************************************************************************************************/
class KeyPressFilter : public QObject
{
    Q_OBJECT

public:

    /*******************************************************************************************//**
     * Constructor.
     **********************************************************************************************/
    KeyPressFilter();

    /*******************************************************************************************//**
     * Event Filter.
     **********************************************************************************************/
    virtual bool eventFilter(QObject* object, QEvent* event) override;

signals:

    /*******************************************************************************************//**
     * Signal to trigger an event (key N or right  arrow).
     **********************************************************************************************/
    void nextEvent();

    /*******************************************************************************************//**
     * Signal to trigger an event (key P or left  arrow).
     **********************************************************************************************/
    void previousEvent();
};

#endif // KEYPRESSFILTER_H
