/***********************************************************************************************//**
 * @author Tanja Munz
 * @file gazedata.h
 **************************************************************************************************/
#ifndef GAZEDATA_H
#define GAZEDATA_H

#include <QString>

/***********************************************************************************************//**
 * This class contains information for raw data samples.
 **************************************************************************************************/
class GazeData
{

public:

    /*******************************************************************************************//**
     * Constructor
     **********************************************************************************************/
    GazeData();

    /*******************************************************************************************//**
     * Returns the x position of the data sample.
     *
     * @return x position
     **********************************************************************************************/
    qreal getXPosition() const;

    /*******************************************************************************************//**
     * Sets the x position of the data sample.
     *
     * @param xPosition x position
     **********************************************************************************************/
    void setXPosition(qreal xPosition);

    /*******************************************************************************************//**
     * Returns the y position of the data sample.
     *
     * @return y position
     **********************************************************************************************/
    qreal getYPosition() const;

    /*******************************************************************************************//**
     * Sets the y position of the data sample.
     *
     * @param yPosition y position
     **********************************************************************************************/
    void setYPosition(qreal yPosition);

private:

    /// x position of data sample.
    qreal m_xPosition;

    /// y position of data sample.
    qreal m_yPosition;
};

#endif // GAZEDATA_H
