/***********************************************************************************************//**
 * @author Tanja Munz
 * @file eyetrackingdata.h
 **************************************************************************************************/
#ifndef EYETRACKINGDATA_H
#define EYETRACKINGDATA_H

#include "participant.h"
#include <vector>

/***********************************************************************************************//**
 * This class contains all eye tracking data for all participants and each trial.
 **************************************************************************************************/
class EyeTrackingData
{

public:

    /*******************************************************************************************//**
     * Constructor.
     **********************************************************************************************/
    EyeTrackingData();

    /*******************************************************************************************//**
     * Destructor.
     **********************************************************************************************/
    ~EyeTrackingData();

    /*******************************************************************************************//**
     * Deletes all participant data permenantly.
     **********************************************************************************************/
    void deleteAllParticipants();

    /*******************************************************************************************//**
     * Clears the list with participant data.
     **********************************************************************************************/
    void clearAllParticipants();

    /*******************************************************************************************//**
     * Returns the number of participants.
     *
     * @return number of participants
     **********************************************************************************************/
    size_t numberOfParticipants() const;

    /*******************************************************************************************//**
     * Returns the participant at the given index.
     **********************************************************************************************/
    Participant* participantAt(const int index);

    /*******************************************************************************************//**
     * Adds a new participant to the end of the list of participants.
     *
     * @param p new participant object.
     **********************************************************************************************/
    void addParticipant(Participant* p);

private:

    /// List of all participant data sets.
    std::vector<Participant*> m_participants;

};

#endif // EYETRACKINGDATA_H
