#ifndef STORM_LOGIC_BOUND_H_
#define	STORM_LOGIC_BOUND_H_

#include "storm/logic/ComparisonType.h"
#include "storm/storage/expressions/Expression.h"
#include "storm/utility/constants.h"


namespace storm {
    namespace logic {
        struct Bound {
            Bound(ComparisonType comparisonType, storm::expressions::Expression const& threshold) : comparisonType(comparisonType), threshold(threshold) {
                // Intentionally left empty.
            }

            ComparisonType comparisonType;
            storm::expressions::Expression threshold;

            template <typename ValueType>
            bool isSatisfied(ValueType const& compareValue) const {
                ValueType thresholdAsValueType = storm::utility::convertNumber<ValueType>(threshold.evaluateAsRational());
                switch(comparisonType) {
                    case ComparisonType::Greater:
                        return compareValue > thresholdAsValueType;
                    case ComparisonType::GreaterEqual:
                        return compareValue >= thresholdAsValueType;
                    case ComparisonType::Less:
                        return compareValue < thresholdAsValueType;
                    case ComparisonType::LessEqual:
                        return compareValue <= thresholdAsValueType;
                }
            }

            friend std::ostream& operator<<(std::ostream& out, Bound const& bound);
        };

        inline std::ostream& operator<<(std::ostream& out, Bound const& bound) {
            out << bound.comparisonType << bound.threshold;
            return out;
        }
    }
    
}

#endif	/* STORM_LOGIC_BOUND_H_ */

