

set(command "make;CFLAGS=-O3 -w -DPIC -DHAVE_IEEE_754 -fno-common -ffast-math -fno-finite-math-only -march=native")
execute_process(
  COMMAND ${command}
  RESULT_VARIABLE result
  OUTPUT_FILE "/home/ae/Desktop/artifact/storm/build/resources/3rdparty/cudd-3.0.0/src/cudd3-stamp/cudd3-build-out.log"
  ERROR_FILE "/home/ae/Desktop/artifact/storm/build/resources/3rdparty/cudd-3.0.0/src/cudd3-stamp/cudd3-build-err.log"
  )
if(result)
  set(msg "Command failed: ${result}\n")
  foreach(arg IN LISTS command)
    set(msg "${msg} '${arg}'")
  endforeach()
  set(msg "${msg}\nSee also\n  /home/ae/Desktop/artifact/storm/build/resources/3rdparty/cudd-3.0.0/src/cudd3-stamp/cudd3-build-*.log")
  message(FATAL_ERROR "${msg}")
else()
  set(msg "cudd3 build command succeeded.  See also /home/ae/Desktop/artifact/storm/build/resources/3rdparty/cudd-3.0.0/src/cudd3-stamp/cudd3-build-*.log")
  message(STATUS "${msg}")
endif()
