#ifndef STORM_STORAGE_GEOMETRY_NATIVEPOLYTOPECONVERSION_HYPERPLANEENUMERATION_H_
#define STORM_STORAGE_GEOMETRY_NATIVEPOLYTOPECONVERSION_HYPERPLANEENUMERATION_H_

#include <vector>
#include "storm/adapters/EigenAdapter.h"

namespace storm{
    namespace storage{
        namespace geometry{

            template< typename ValueType>
            class HyperplaneEnumeration {
            public:

                typedef StormEigen::Matrix<ValueType, StormEigen::Dynamic, StormEigen::Dynamic> EigenMatrix;
                typedef StormEigen::Matrix<ValueType, StormEigen::Dynamic, 1> EigenVector;

                HyperplaneEnumeration() = default;
                virtual ~HyperplaneEnumeration() = default;

                /*
                 * Generates the vertices of the given polytope by enumerating all intersection points generated by subsets of hyperplanes of size hPoly.dimension().
                 * If the given flag is true, this method will also compute
                 *  * the minimal set of hyperplanes which represent the given hPoly (can be used to remove redundant hyperplanes), and
                 *  * for each hyperplane, the set of (non-redundant) vertices that lie on that hyperplane.
                 *
                 * Use the provided getter methods to retrieve the results
                 *
                 * @return true iff conversion was successful.
                 */
                void generateVerticesFromConstraints(EigenMatrix const& constraintMatrix, EigenVector const& constraintVector, bool generateRelevantHyperplanesAndVertexSets);

                std::vector<EigenVector>& getResultVertices();

                /*!
                 * Returns the set of halfspaces which are not redundant
                 * @note the returned matrix and vector are empty if the corresponding flag was false
                 */
                EigenMatrix& getRelevantMatrix();
                EigenVector& getRelevantVector();

                /*!
                 * Returns for each hyperplane the set of vertices that lie on that hyperplane.
                 * A vertex is given as an index in the relevantVertices vector.
                 * @note the returned vector is empty if the corresponding flag was false
                 */
                std::vector<std::vector<uint_fast64_t>>& getVertexSets();


                /*
                 * Returns true if the hyperplanes with indices of subset and item are all linear independent
                 * Note that this is also used by the hybrid polytope.
                 */
                static bool linearDependenciesFilter(std::vector<uint_fast64_t> const& subset, uint_fast64_t const& item, EigenMatrix const& A);

            private:
                std::vector<EigenVector> resultVertices;
                EigenMatrix relevantMatrix;
                EigenVector relevantVector;
                std::vector<std::vector<uint_fast64_t>> vertexSets;
            };
        }
    }
}

#endif /* "STORM_STORAGE_GEOMETRY_NATIVEPOLYTOPECONVERSION_HYPERPLANEENUMERATION_H_" */