/**
 * @file CMakeOptions.h
 * @author Gereon Kremer <gereon.kremer@cs.rwth-aachen.de>
 */

#pragma once

#include <iostream>

namespace carl {

void printCMakeOptions(std::ostream& os);

namespace cmakeoptions {

	static constexpr auto _ALLWARNINGS = "OFF";
	static constexpr auto _BIN_INSTALL_DIR = "/usr/local/lib";
	static constexpr auto _BUILD_ADDONS = "OFF";
	static constexpr auto _BUILD_DOXYGEN = "OFF";
	static constexpr auto _BUILD_STATIC = "OFF";
	static constexpr auto _CARL_TARGETS = "lib_carl";
	static constexpr auto _CLANG_FORMAT = "CLANG_FORMAT-NOTFOUND";
	static constexpr auto _CLANG_SANITIZER = "none";
	static constexpr auto _CLANG_TIDY = "CLANG_TIDY-NOTFOUND";
	static constexpr auto _CMAKE_BUILD_TYPE = "RELEASE";
	static constexpr auto _CMAKE_INSTALL_DIR = "/usr/local/lib/cmake/carl";
	static constexpr auto _CMAKE_INSTALL_PREFIX = "/usr/local";
	static constexpr auto _COMPARE_WITH_Z3 = "OFF";
	static constexpr auto _COVERAGE = "OFF";
	static constexpr auto _DEVELOPER = "OFF";
	static constexpr auto _ENABLE_PACKAGING = "OFF";
	static constexpr auto _EXECUTABLE_OUTPUT_PATH = "/home/ae/Desktop/artifact/carl/build/bin";
	static constexpr auto _EXPORT_TO_CMAKE = "ON";
	static constexpr auto _FORCE_SHIPPED_GMP = "OFF";
	static constexpr auto _FORCE_SHIPPED_RESOURCES = "OFF";
	static constexpr auto _INCLUDE_INSTALL_DIR = "/usr/local/include";
	static constexpr auto _LIB_INSTALL_DIR = "/usr/local/lib";
	static constexpr auto _LOGGING = "OFF";
	static constexpr auto _LOGGING_DISABLE_INEFFICIENT = "OFF";
	static constexpr auto _PRUNE_MONOMIAL_POOL = "ON";
	static constexpr auto _THREAD_SAFE = "ON";
	static constexpr auto _TIMING = "OFF";
	static constexpr auto _USE_BLISS = "OFF";
	static constexpr auto _USE_CLN_NUMBERS = "ON";
	static constexpr auto _USE_COCOA = "OFF";
	static constexpr auto _USE_COTIRE = "OFF";
	static constexpr auto _USE_GINAC = "ON";
	static constexpr auto _USE_MPFR_FLOAT = "OFF";
	static constexpr auto _USE_Z3_NUMBERS = "OFF";
}

}
