set(carl_VERSION 14.18.4-g3097adc1)

set( carl_VERSION_MAJOR 14)
set( carl_VERSION_MINOR 18)
set( carl_VERSION_PATCH )
set( carl_MINORYEARVERSION 14)
set( carl_MINORMONTHVERSION 18)
set( carl_MAINTENANCEVERSION )
   
get_filename_component(carl_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)



if(NOT TARGET CLN_SHARED)
	add_library(CLN_SHARED SHARED IMPORTED)
	set_target_properties(CLN_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/libcln.so")
	set_target_properties(CLN_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET CLN_STATIC)
	add_library(CLN_STATIC STATIC IMPORTED)
	set_target_properties(CLN_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/libcln.a")
	set_target_properties(CLN_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
	set_target_properties(CLN_STATIC PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES "GMP_STATIC")
	set_target_properties(CLN_STATIC PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES "GMP_STATIC")
endif()

if(NOT TARGET GINAC_SHARED)
	add_library(GINAC_SHARED SHARED IMPORTED)
	set_target_properties(GINAC_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/libginac.so")
	set_target_properties(GINAC_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include/ginac")
	set_target_properties(GINAC_SHARED PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES "CLN_SHARED")
endif()

if(NOT TARGET GINAC_STATIC)
	add_library(GINAC_STATIC STATIC IMPORTED)
	set_target_properties(GINAC_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/libginac.a")
	set_target_properties(GINAC_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include/ginac")
	set_target_properties(GINAC_STATIC PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES "CLN_STATIC")
endif()

if(NOT TARGET GMP_SHARED)
	add_library(GMP_SHARED SHARED IMPORTED)
	set_target_properties(GMP_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libgmp.so")
	set_target_properties(GMP_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include/x86_64-linux-gnu")
endif()

if(NOT TARGET GMP_STATIC)
	add_library(GMP_STATIC STATIC IMPORTED)
	set_target_properties(GMP_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libgmp.a")
	set_target_properties(GMP_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include/x86_64-linux-gnu")
endif()

if(NOT TARGET GMPXX_SHARED)
	add_library(GMPXX_SHARED SHARED IMPORTED)
	set_target_properties(GMPXX_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libgmpxx.so")
	set_target_properties(GMPXX_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET GMPXX_STATIC)
	add_library(GMPXX_STATIC STATIC IMPORTED)
	set_target_properties(GMPXX_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libgmpxx.a")
	set_target_properties(GMPXX_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
	set_target_properties(GMPXX_STATIC PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES "GMP_STATIC")
endif()

if(NOT TARGET EIGEN3)
	add_library(EIGEN3 INTERFACE IMPORTED)
	set_target_properties(EIGEN3 PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include/eigen3")
endif()

if(NOT TARGET Boost_SHARED)
	add_library(Boost_SHARED INTERFACE IMPORTED)
	set_target_properties(Boost_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
	set_target_properties(Boost_SHARED PROPERTIES INTERFACE_LINK_LIBRARIES "Boost_filesystem_SHARED;Boost_system_SHARED;Boost_program_options_SHARED;Boost_regex_SHARED;Boost_unit_test_framework_SHARED")
endif()

if(NOT TARGET Boost_filesystem_SHARED)
	add_library(Boost_filesystem_SHARED SHARED IMPORTED)
	set_target_properties(Boost_filesystem_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_filesystem.so")
	set_target_properties(Boost_filesystem_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_system_SHARED)
	add_library(Boost_system_SHARED SHARED IMPORTED)
	set_target_properties(Boost_system_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_system.so")
	set_target_properties(Boost_system_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_program_options_SHARED)
	add_library(Boost_program_options_SHARED SHARED IMPORTED)
	set_target_properties(Boost_program_options_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_program_options.so")
	set_target_properties(Boost_program_options_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_regex_SHARED)
	add_library(Boost_regex_SHARED SHARED IMPORTED)
	set_target_properties(Boost_regex_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_regex.so")
	set_target_properties(Boost_regex_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_unit_test_framework_SHARED)
	add_library(Boost_unit_test_framework_SHARED SHARED IMPORTED)
	set_target_properties(Boost_unit_test_framework_SHARED PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_unit_test_framework.so")
	set_target_properties(Boost_unit_test_framework_SHARED PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_STATIC)
	add_library(Boost_STATIC INTERFACE IMPORTED)
	set_target_properties(Boost_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
	set_target_properties(Boost_STATIC PROPERTIES INTERFACE_LINK_LIBRARIES "Boost_filesystem_STATIC;Boost_system_STATIC;Boost_program_options_STATIC;Boost_regex_STATIC;Boost_unit_test_framework_STATIC")
endif()

if(NOT TARGET Boost_filesystem_STATIC)
	add_library(Boost_filesystem_STATIC STATIC IMPORTED)
	set_target_properties(Boost_filesystem_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_filesystem.a")
	set_target_properties(Boost_filesystem_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_system_STATIC)
	add_library(Boost_system_STATIC STATIC IMPORTED)
	set_target_properties(Boost_system_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_system.a")
	set_target_properties(Boost_system_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_program_options_STATIC)
	add_library(Boost_program_options_STATIC STATIC IMPORTED)
	set_target_properties(Boost_program_options_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_program_options.a")
	set_target_properties(Boost_program_options_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_regex_STATIC)
	add_library(Boost_regex_STATIC STATIC IMPORTED)
	set_target_properties(Boost_regex_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_regex.a")
	set_target_properties(Boost_regex_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()

if(NOT TARGET Boost_unit_test_framework_STATIC)
	add_library(Boost_unit_test_framework_STATIC STATIC IMPORTED)
	set_target_properties(Boost_unit_test_framework_STATIC PROPERTIES IMPORTED_LOCATION "/usr/lib/x86_64-linux-gnu/libboost_unit_test_framework.a")
	set_target_properties(Boost_unit_test_framework_STATIC PROPERTIES INTERFACE_INCLUDE_DIRECTORIES "/usr/include")
endif()


set(CARL_LOGGING "OFF")
set(CARL_TIMING "OFF")
set(CARL_FORCE_SHIPPED_RESOURCES "OFF")
set(CARL_FORCE_SHIPPED_GMP "OFF")
set(CARL_USE_GINAC "ON")
set(CARL_USE_CLN_NUMBERS "ON")
set(CARL_USE_COCOA "OFF")
set(CARL_USE_BLISS "OFF")
set(CARL_USE_MPFR_FLOAT "OFF")
set(CARL_BUILD_STATIC "OFF")
set(CARL_BUILD_DOXYGEN "OFF")
set(CARL_THREAD_SAFE "ON")
 
# Our library dependencies (contains definitions for IMPORTED targets)
if(NOT TARGET lib_carl AND NOT carl_BINARY_DIR)
  include("${carl_CMAKE_DIR}/carlTargets.cmake")
endif()


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was carlConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
   
set(carl_INCLUDE_DIR "${carl_CMAKE_DIR}/../../../include")

set(carl_LIBRARIES lib_carl)
check_required_components(carl)
