#####################
# SACs & RADs #######
# natives spp only ##
# 10 plots    #######
# Alternative Scen3:#
#  elevation range ##
#####################

require(lme4)
require(MuMIn)
require(lmerTest)
require(ggeffects)

#################
# SACs ##########
#################

################
# Scenario 3 ###
################

sac.tog3<-read.csv("Cleaned_Data/Scen3_Natives_ElevR_10plots_curves_estimates.csv")

sac.tog3$iteration<-as.factor(sac.tog3$iteration)
sac.tog3$geo_entity2<-as.factor(sac.tog3$geo_entity2)

sac.tog3$geo_entity2<-as.character(sac.tog3$geo_entity2)
sac.tog3$geo_entity2<-ifelse(sac.tog3$geo_entity2=="Hawai'i Island","Hawai'i",sac.tog3$geo_entity2)
sac.tog3$geo_entity2<-ifelse(sac.tog3$geo_entity2=="Kaua'i Island","Kaua'i",sac.tog3$geo_entity2)
sac.tog3$geo_entity2<-ifelse(sac.tog3$geo_entity2=="O'ahu Island","O'ahu",sac.tog3$geo_entity2)
sac.tog3$geo_entity2<-as.factor(sac.tog3$geo_entity2)

sac.tog3$geo_entity2<-as.factor(sac.tog3$geo_entity2)
sac.tog3$geo_entity2<-factor(sac.tog3$geo_entity2,levels=c("Hawai'i","Maui Nui","O'ahu","Kaua'i"))

# fit model

b<-lmer(qD~log(m)+geo_entity2+log(m):geo_entity2+(1|geo_entity2:iteration),
        data=sac.tog3,control=lmerControl(optimizer="Nelder_Mead"))

summ_sac_scen3<-broom::tidy(anova(b,ddf="Satterthwaite"))
sac_scen2_r3<-r.squaredGLMM(b,pj2014 = FALSE)

plot(fitted(b),residuals(b))
abline(h=0,col="red")

qqnorm(residuals(b))
qqline(residuals(b))

qqnorm(unlist(ranef(b)))
qqline(unlist(ranef(b)))

# make predictions

pred2 <- ggeffect(b, terms = c("m [exp]","geo_entity2"),type="fe")

pred2$group<-as.character(pred2$group)
pred2$group<-ifelse(pred2$group=="Hawai'i Island","Hawai'i",pred2$group)
pred2$group<-ifelse(pred2$group=="Kaua'i Island","Kaua'i",pred2$group)
pred2$group<-ifelse(pred2$group=="O'ahu Island","O'ahu",pred2$group)
pred2$group<-as.factor(pred2$group)

pred2$group<-as.factor(pred2$group)
pred2$group<-factor(pred2$group,levels=c("Hawai'i","Maui Nui","O'ahu","Kaua'i"))
elev_sac_pred3<-pred2

#############
# RADs ######
#############

################
# Scenario 3 ###
################

rad.tog3<-read.csv("Cleaned_Data/Scen3_Natives_ElevR_10plots_RADs.csv",sep=",",header=T)

rad.tog3$iteration<-as.factor(rad.tog3$iteration)
rad.tog3$logRelAbund<-log(rad.tog3$RelAbund)

# fit model

rad3<-lmer(Rank_N~ poly(logRelAbund,3)*geo_entity2+(1|geo_entity2:iteration),
           data=rad.tog3)

summ_rad_scen3<-broom::tidy(anova(rad3,ddf="Satterthwaite"))
rad_scen3_r2<-r.squaredGLMM(rad3,pj2014 = FALSE)

plot(fitted(rad3),residuals(rad3))
abline(h=0,col="red")

qqnorm(residuals(rad3))
qqline(residuals(rad3))

qqnorm(unlist(ranef(rad3)))
qqline(unlist(ranef(rad3)))

# make predictions
rad_pred3 <- ggeffect(rad3, terms = c("logRelAbund [n=8.30]","geo_entity2"),type="fe")

rad_pred3$group<-as.character(rad_pred3$group)
rad_pred3$group<-ifelse(rad_pred3$group=="Hawai'i Island","Hawai'i",rad_pred3$group)
rad_pred3$group<-ifelse(rad_pred3$group=="Kaua'i Island","Kaua'i",rad_pred3$group)
rad_pred3$group<-ifelse(rad_pred3$group=="O'ahu Island","O'ahu",rad_pred3$group)
rad_pred3$group<-as.factor(rad_pred3$group)

rad_pred3$group<-as.factor(rad_pred3$group)
rad_pred3$group<-factor(rad_pred3$group,levels=c("Hawai'i","Maui Nui","O'ahu","Kaua'i"))
elev_rad_pred3<-rad_pred3

########################
# save data   ##########
########################

save(elev_sac_pred3,elev_rad_pred3,
     file="Cleaned_Data/modelpredictions_SAC_RAD_Scen23_Native_ElevR_10plots.RData")

save(sac_scen2_r3, summ_sac_scen3, 
    rad_scen3_r2,summ_rad_scen3,file="Cleaned_Data/model_summary_SAC_RAD_Scen23_Native_ElevR_10plots.RData")