context("dramaHead()")

data(rksp.0)

segmentedText <- segment(rksp.0$text, rksp.0$segments)

t <- dramaHead(segmentedText, n=1)
test_that("dramaHead(segmentedText, n=1) subsets one act", {
  expect_length(unique(t$begin.Act), 1)
})

t <- dramaHead(segmentedText, n=3)
test_that("dramaHead(segmentedText, n=3) subsets one act", {
  expect_length(unique(t$begin.Act), 1)
})

suppressWarnings(t <- dramaHead(segmentedText, n=6))
test_that("dramaHead(segmentedText, n=6) throws a warning and returns an empty table because the play only has 5 acts", {
  expect_warning(dramaHead(segmentedText, n=6), "Play has only 5 acts.")
  expect_length(unique(t$begin.Act), 0)
  expect_that(nrow(t), equals(0))
})

t <- dramaHead(segmentedText, n=1, op="<=")
test_that("dramaHead(segmentedText, n=1, op='<=') subsets one act", {
  expect_length(unique(t$begin.Act), 1)
})

t <- dramaHead(segmentedText, n=3, op="<=")
test_that("dramaHead(segmentedText, n=3, op='<=') subsets three acts", {
  expect_length(unique(t$begin.Act), 3)
})

suppressWarnings(t <- dramaHead(segmentedText, n=6, op="<="))
test_that("dramaHead(segmentedText, n=6, op='<=') throws a warning and returns an empty table because the play only has 5 acts", {
  expect_warning(dramaHead(segmentedText, n=6, op="<="), "Play has only 5 acts.")
  expect_length(unique(t$begin.Act), 0)
})

t <- dramaHead(segmentedText, by="Scene", n=1)
test_that("dramaHead(segmentedText, by='Scene', n=1) subsets one scene", {
  expect_length(unique(t$begin.Scene), 1)
})

t <- dramaHead(segmentedText, by="Scene", n=12)
test_that("dramaHead(segmentedText, by='Scene', n=12) subsets one scene", {
  expect_length(unique(t$begin.Scene), 1)
})

t <- dramaHead(segmentedText, by="Scene", n=30)
test_that("dramaHead(segmentedText, by='Scene', n=30) subsets one scene", {
  expect_length(unique(t$begin.Scene), 1)
})