% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSpiderWebs}
\alias{plotSpiderWebs}
\title{Spider-Webs}
\usage{
plotSpiderWebs(dstat, symbols = c(17, 16, 15, 4, 8), cglcol = "black",
  legend = TRUE, legend.cex = 0.7, legend.pos.x = "bottomright",
  legend.pos.y = NA, legend.horizontal = FALSE, pcol = qd.colors,
  ...)
}
\arguments{
\item{dstat}{A data frame containing data, e.g., output from dictionaryStatistics()}

\item{symbols}{Symbols to be used in the plot}

\item{cglcol}{The color for the spider net}

\item{legend}{Whether to print a legend}

\item{legend.cex}{Scaling factor for legend}

\item{legend.pos.x}{X position of legend}

\item{legend.pos.y}{Y position of legend}

\item{legend.horizontal}{Whether to print legend horizontally or vertically}

\item{pcol}{The line color(s)}

\item{...}{Miscellaneous arguments to be given for radarchart().}
}
\description{
Generates spider-web like plot. 
Spider webs may look cool, but they are terrible 
to interpret. You should think of using a bar 
chart to represent the same information. \emph{You have been warned.}
}
\note{
radar charts and spider web plots are dangerous, 
they can easily become misleading. They are in this package 
for historic reasons, but should not be used anymore.
}
\examples{
data(rksp.0)
fnames <- c("Krieg", "Liebe", "Familie", "Ratio","Religion")
ds <- dictionaryStatistics(rksp.0, normalizeByField=TRUE, 
                           fieldnames=fnames)
plotSpiderWebs(ds)
}
