% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{dramaTail}
\alias{dramaTail}
\title{Extract section}
\usage{
dramaTail(input, by = c("Act", "Scene"), op = "==", n = 1)
}
\arguments{
\item{input}{Segmented text (can be multiple texts)}

\item{by}{Act or Scene, or matching substring}

\item{op}{Whether to extract exactly one or more than one}

\item{n}{The number of segments to extract}
}
\description{
Extracts a sub segment of the text(s).
The result is an empty table if more scenes or acts
are given than exist in the play. In this case, a
warning is printed.
}
\examples{
\dontrun{
data(rksp.0)
# Extract the second last scene
dramaTail(rksp.0$text, by="Scene", op="==", n=2)
}
}
