% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaryStatistics.R
\name{loadFields}
\alias{loadFields}
\title{Dictionary Handling}
\usage{
loadFields(fieldnames = c("Liebe", "Familie"),
  baseurl = paste("https://raw.githubusercontent.com/quadrama/metadata/master",
  ensureSuffix(directory, fileSep), sep = fileSep),
  directory = "fields/", fileSuffix = ".txt", fileSep = "/")
}
\arguments{
\item{fieldnames}{A list of names for the dictionaries. It is expected that files with that name can be found below the URL.}

\item{baseurl}{The base path delivering the dictionaries. Should end in a /, field names will be appended and fed into read.csv().}

\item{directory}{The last component of the base url. 
Useful to retrieve enriched word fields from metadata repo.}

\item{fileSuffix}{The suffix for the dictionary files}

\item{fileSep}{The file separator used to construct the URL
Can be overwritten to load local dictionaries.}
}
\description{
\code{loadFields()} loads dictionaries that are available on the web as plain text files.
}
\section{File Format}{

Dictionary files should contain one word per line, with no comments 
or any other meta information. 
The entry name for the dictionary is given as the file name. 
It's therefore best if it does not contain
special characters. The dictionary must be in UTF-8 encoding, and the 
file needs to end on .txt.
}

\examples{
\dontrun{
# retrieves word fields from github
fields <- loadFields(fieldnames=c("Liebe", "Familie", "Krieg"))


# retrieves word fields from local directory (under windows)
fields <- loadFields(filednames=c("Health", "Death"),
                     baseurl="c:\\\\path\\\\to\\\\local\\\\directory",
                     fileSep="\\\\")
}
}
