# Draw the shadow and trailing lines of 2 planes. This is not really
# a simulation.. just a way to illustrate how to move objects around!
from vtkplotter import *

world = Box([0,0,0], 30, 15, 8).wireframe()

plane1 = load(datadir+"cessna.vtk").c("green").addTrail().addShadow(y=-7.5)
plane2 = plane1.clone().c("tomato") # make a clone copy of the first plane

# Setup the scene
show(world, plane1, plane2, axes=1, bg="white", viewup="z", interactive=0)

for t in arange(0, 3.2, 0.01):
    plane1.pos(9*t-15, 2-t, sin(3-t)).rotateX(0+t) # make up some movement
    plane2.pos(8*t-15, t-2, sin(t-3)).rotateX(2-t) # for the 2 planes
    show(world, plane1, plane2)

interactive()
