import pyblake2
import io
import os

import logging
logFormatter = logging.Formatter("%(asctime)s [%(levelname)-5.5s]  %(message)s")
rootLogger = logging.getLogger()
fileHandler = logging.FileHandler("run.log", mode="w")
fileHandler.setFormatter(logFormatter)
rootLogger.addHandler(fileHandler)
consoleHandler = logging.StreamHandler()
consoleHandler.setFormatter(logFormatter)
rootLogger.addHandler(consoleHandler)

rootLogger.setLevel(logging.DEBUG)


def self_log():
    ## Log myself with hash value
    def b2sum(src, digest_size_in_bytes=64, length=io.DEFAULT_BUFFER_SIZE):
        """Calculates a BLAKE2 hash sum of a file, given as file name.
        Returns the b2sum.
        """
        b2 = pyblake2.blake2b(digest_size=digest_size_in_bytes)
        with io.open(src, mode="rb") as fd:
            for chunk in iter(lambda: fd.read(length), b''):
                b2.update(chunk)
        return b2.hexdigest()
    path = os.path.abspath(__file__)
    logger = logging.getLogger(__name__)
    logger.info(f"Hi, this is: '{__name__}'")
    logger.info("I am located here:")
    logger.info(path)
    logger.info("My b2sum hash is:")
    logger.info(b2sum(path))
self_log()


import importlib.util
spec = importlib.util.spec_from_file_location("data_toolbox", "./files/data_toolbox.py")
data_toolbox = importlib.util.module_from_spec(spec)
spec.loader.exec_module(data_toolbox)


import os

print("I am here:")
print(os.getcwd())

os.chdir("./files/")

print("...changed to:")
print(os.getcwd())

data = data_toolbox.Data()
data.parse_args(argv=["-c", "config.txt"])

data.read_data()
#data.rename_cols()
data.sub_background()
#data.pathlength_correction()
#data.plot_data()
data.rearrange_data()
data.group_data()
#data.plot_all_timepoints()
data.conversion_rate()
#data.plot_conversion_rates()

import pandas as pd
df = pd.read_csv("csv_files/08_conv_rates.csv")
df = df.dropna()
def return_educt_concentration_from_Condition_Name(cond_name):
    return float(cond_name.split("_dT_")[0])
df["educt_concentration"] = df.Condition_Name.apply(return_educt_concentration_from_Condition_Name)
df["mole_fraction"] = ( df.educt_concentration / 100 )

print(df)



import statsmodels.formula.api as smf
model = smf.ols(formula='Par_a ~ mole_fraction -1', data=df).fit()
print(model.summary())


import matplotlib.pyplot as plt
import numpy as np



fig = plt.figure(figsize=(5,5))
ax = fig.add_subplot(111)
plt.plot([0,1],[0,1], "-", color="black", linewidth=4) # label="ideal")
plt.xlim((-0.1, 1.1))
plt.ylim((-0.1, 1.1))

plt.errorbar(x=df.mole_fraction, y=df.Par_a, yerr=1.96 * np.sqrt(df.Variance_a), markersize=5, fmt="s", capsize=8) # label="predicted"

plt.xlabel("mole fraction (Thymidine) / []")
plt.ylabel("predicted mole fraction (Thymidine) / []")
plt.title(
    f"Predicted mole fraction of Thymidine from spectral fits \n \
    against true mole fractions. Error bars = 95%CI of fit.", fontsize=12)

ax.text(0.05, 0.95, f"R² = {round(model.rsquared,3)}", horizontalalignment="left", bbox=dict(facecolor='white', alpha=0.5))

#plt.legend()

plt.tight_layout()
plt.savefig("figure1__predicted_vs_actual_mole_fractions_of_thymidine.svg")
plt.close("all")


