% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_features.R
\name{extract_features}
\alias{extract_features}
\title{A Time-Series Feature Extraction Package}
\usage{
extract_features(df, group_var, value_var, features = "all",
  custom_feature_list = NA, data_confirm = T, return_timing = T,
  verbose = T)
}
\arguments{
\item{df}{class: data.frame}

\item{group_var}{class: string, or vector of strings; description: column name(s) to group by}

\item{value_var}{class: string; description: column name with value 'y' in data}

\item{features}{class: pre-defined string or list of vectors; Pre-defined strings are: 'all', 'simple', 'change', 'meta', 'count','intensive'}

\item{custom_feature_list}{class: pre-defined string or list of vectors; if features="custom", can supply a vector of features of interest}

\item{data_confirm}{class: boolean; T = confirming data is in long format}

\item{return_timing}{class: boolean; T = return dataframe with timing for each feature}

\item{verbose}{class: boolean; T = display status, debugging info}
}
\description{
A Time-Series Feature Extraction Package
}
\examples{
extract_features(df,group_var='id',value_var='y',features='simple')
extract_features(df,group_var=c('id','month'),'y',features='all')
}
