# Turing Way - sharing lessons learned in doing reproducible research

Reproducible research is work that can be independently verified. 
In practice, it means sharing the data and code that were used to generate published results - yet this is often easier said than done.

The Turing Way is a guide to reproducible data science that will support students and academics as they develop their code, with the aim of helping them produce work that will be regarded as gold-standard examples of trustworthy and reusable research. 
It is openly developed and any and all questions, comments and recommendations are welcome at our GitHub repository: https://github.com/alan-turing-institute/the-turing-way 

We would like to hear your experience in making your research reproducible and things you have learned that you think others should know! 

Filling this form should take no longer than 5 - 10 minutes depending on the amount of detail you provide.  

These testimonies of tips and tricks will be published in the Turing Way handbook so please only include information that you are comfortable for others to read or anonymize where appropriate.
We may make minor revisions to your submission for style or clarity.

## Tell us who you are

Please share your name and your job title (feel free to interpret that as broadly as you'd like!)
For example: Jessica Madeupname, postdoctoral researcher.
You can leave this blank if you would prefer to share an experience anonymously.

> Free text answer

## Which issue(s) have you encountered regarding reproducibility of research in your field?

These can be big or small.
Whatever has made it hard for you to make your work reproducible!

> Free text answer

## What "gotchas" did you encounter in trying to make your work reproducible that you would like others to know about?

Gotcha (programming): a counter-intuitive, but documented, behavior in a computer system (as opposed to a bug) [Source: Wikipedia: https://en.wikipedia.org/wiki/Gotcha]

> Free text answer

## What are your top tips and tricks to make research reproducible

We really appreciate any advice that you can pass along!

> Free text answer

## If you could go back in time to the start of your project, what would you tell yourself?

This might overlap with the tips and tricks or gotchas.
You don't have to repeat yourself.
But if there's anything else you'd say, please let us know!

> Free text answer

## I understand that the answers given above will be made public at the Turing Way GitHub repository.
*mandatory field*
> Check box: yes, no


## Contact information

This will not be made public.
It will only be accessible by the core Turing Way project team.
We will use it to share with you any edited versions of your contribution.
We will not share it with anyone else.

> Free text answer

**Thank you so much for your contribution!**  

The Turing Way project team

Contact: kwhitaker@turing.ac.uk; https://gitter.im/alan-turing-institute/the-turing-way
