# Who's who on the Turing Way team

## Contributors
Legend (source:
[https://github.com/kentcdodds/all-contributors](https://github.com/kentcdodds/all-contributors))

| Emoji | Represents                                                                  |
|:------|:----------------------------------------------------------------------------|
| 💬    | Answering Questions (on gitter, GitHub, or in person) |
| 🐛    | Bug reports                                                                 |
| 📝    | Blogposts                                                                   |
| 💻    | Code                                                                        |
| 📖    | Documentation and specification                                             |
| 🎨    | Design                                                                      |
| 💡    | Examples                                                                    |
| 📋    | Event Organizers                                                            |
| 💵    | Financial Support                                                           |
| 🔍    | Funding/Grant Finders                                                       |
| 🤔    | Ideas & Planning                                                            |
| 🚇    | Infrastructure (Hosting, Build-Tools, etc)                                  |
| 🔌    | Plugin/utility libraries                                                    |
| 👀    | Reviewed Pull Requests                                                      |
| 🔧    | Tools                                                                       |
| 🌍    | Translation                                                                 |
| ⚠️    | Tests                                                                       |
| ✅     | Tutorials                                                                   |
| 📢    | Talks                                                                       |
| 📹    | Videos                                                                      |

The following individuals have contributed to the Turing Way (in alphabetical order by last name). 
If you contributed to the Turing Way and your name is not listed, please add it.

- Becky Arnold 💬💻📖👀
- Lorena A. Barba 🤔 
- Louise Bowler 💬💻📖💡📋👀
- Sarah Gibson 💬💻📖🔧👀📢
- Tim Head 💬🤔
- Patricia Herterich 💬📖👀
- Rosie Higman 💬📋👀
- Anna Krystalli 💬💡📋 👀
- Alexander Morley 💬👀⚠️
- Martin O'Reilly 💬🔧
- Oliver Strickson 💬📖
- Kirstie Whitaker 💬🎨🔍🤔👀⚠️📢

## Core team
This will give you a little introduction to the various members of the Turing Way core development team.

* [Kirstie Whitaker](#kirstie-whitaker) @kirstiejane
* [Patricia Herterich](#patricia-herterich) @pherterich 
* [Alexander Morley](#alexander-morley) @alexmorley
* [Becky Arnold](#becky-arnold) @r-j-arnold
* [Martin O’Reilly](#martin-oreilly) @martintoreilly
* [Anna Krystalli](#anna-krystalli) @annakrystalli
* [Sarah Gibson](#sarah-gibson) @sgibson91
* [Louise Bowler](#louise-bowler) @LouiseABowler
* [Rosie Higman](#rosie-higman) @rosiehigman 
* [Rachael Ainsworth](#rachael-ainsworth) @rainsworth


## Contributor biographies
### Kirstie Whitaker

**Who are you?**

I'm a research fellow at the Alan Turing Institute and a senior research associate in the Department of Psychiatry at the University of Cambridge.
I have a PhD in Neuroscience from the University of California at Berkeley and conducted my postdoctoral research at the University of Cambridge in the Brain Mapping Unit.
I am a Mozilla fellowship (2016) and Fulbright scholarship (2007) alumna.

**What are you passionate about?**

I'm really passionate about the concept of making science "open for all".
I take that to mean we should share all of our outputs - the data, code and protocols that we develop - whether they're "significant" or not.
But it also includes making those outputs FAIR - findable, accessible, interoperable and reusable. I am an advocate for greater diversity in STEM and in data science and particularly passionate about improving the ways we reward collaborative and supportive working.
Finally, I'd like to pivot to having data science project be developed in the open from the beginning and with a decision making governance processs that is inclusive and community-lead.

**Why do you care about the Turing Way?**

I've done a lot of advocacy for changing research culture to make our work more efficient and effective, and I've noticed that we need to address the power structures in academia if we are to truly make research reproducible by default.
For example, if a PhD student's supervisor says to them on the very first day: I want you to use git for version control and to keep your data in this particular format, that student is very likely to easily develop helpful version control and data management skills.
And in the same vein, when funders require open access publications, then the senior members of a research project will do exactly that.
I'm excited to build the Turing Way to both inspire the people who DO the research to make all their outputs as accessible as possible, and to nudge everyone else in the ecosystem to care about the work required to do so.

### Patricia Herterich

**Who are you?**

I'm the Research Repository Advisor at the University of Birmingham which basically means I support research data management and open research as much as possible and I'm in charge of repository systems (the library kind) to enable this.
From 2012 to 2016, I've worked at CERN as a doctoral student supporting Open Research stuff and still have to finish writing up the results in my PhD thesis and submit to the Humboldt-Universitaet in Berlin but tend to spend the time watching Netflix or crocheing :-(

**What are you passionate about?**

Making the world a better place. I think opening up research is part of that as open access to publications is key to provide knowledge to people who cannot afford subscriptions and going beyond this and sharing code and data has the potential to make research more inclusive and win back trust in experts and scientific results.
I really care about collaborating and get really excited about trying new tools if my limited tech skills allow.
I'd like to have taken down Elsevier by the end of my career. ;-)

**Why do you care about the Turing Way?**

I really think ways of working and reward structures in academia need to change as most discussions around open research end up with "how does that help me with my career". As a librarian, it feels like our influence is often limited, but I try to set up workshops/events to at least get the discussion started and give especially PhD students the feeling that they can challenge the status quo and there will be people in the institution that will support them that might not be their supervisor.
I really love how the Turing Way aims to create good examples and I hope we can develop some ideas and resources that can have a positive impact in changing the current system.

### Alexander Morley

**Who are you?**

I am a Mozilla Fellow (2018-) and a PhD Candidate at the MRC Brain Network Dynamics Unit at the University of Oxford (2015-).
I also receive support from the Software Sustainability Institute Fellowship programme (2018) and Microsoft/Research Software England Cloud Computing Fellowship programme (2018).
My undergraduate degree was in Medicine at the University of Oxford (2012-2015).

**What are you passionate about?**

I really want research to be accessible, but in a much broader sense than the word is often used. I would love to see a world where re-mixing research is a common thing, whether that be re-mixing figures to make them easier to understand, re-using data to generate new insights, or testing new methods to see how our theories might need to change.

Slightly less on topic, but just as important, I am also passionate about the development and adoption of best-practices in governance. Safe and inclusive spaces are all too rare in acedemia, and I think some part of that can be solved by doing away with our laissez-faire attitude towards governance and management.

**Why do you care about the Turing Way?**

When people don't use best practices in data science its almost always because they either don't know about them, or feel they don't have time. Advocates will tell people that the time is saved in the long-term, but it's a hard sell.

By providing concrete, incremental, but authoratitve, guidance I believe the Turing Way could provide the nudge that allows people to realise the benefits for themselves, and lowers the barrier for more researchers to acquire these highly valued skills.


### Becky Arnold

**Who are you?**

I'm an astrophysics PhD student at the University of Sheffield and I do computer simulations of star forming regions. I'm a 2018 Software Sustainability Institute fellow using the funds to organise talks and workshops about various issues surrounding good programming practise.


**What are you passionate about?**

Science. All over the world humans come together to try and figure out how the universe works and that's *amazing*, just as amazing as the answers themselves. I'm also passionate about how we actually do that science, making sure it's accurate and reproducible. If it isn't both of those things we haven't moved forwards much, or worse still end up going in circles.

I care deeply about changing the culture of academia, in which abuse of power (both minor and major) is all too common.


**Why do you care about the Turing Way?**

Because I've met so many people that want to code well and follow best practise, which will benefit science enormously, but struggle to know how to do so. While there are lots of fantastic resources out there they're often scattered and the Turing Way can improve that. I also hope that it can convince people that don't consider themselves capable of being good programmers that there are steps they can take to drastically improve their coding.


### Martin O'Reilly

**Who are you?**

I'm Principal Research Software Engineer and Deputy Head of the Research Engineering Group at the Alan Turing Institute.
My focus is on using good software engineering practices to increase the impact of research software by making it reusable, reliable and robust.
I also have a strong interest in reproducible research, and am working to improve the tools and working practices at the Turing to make it easier for our researchers to work reproducibly.
I've moved back and forth between industry and academia over the years, gaining an MSc in Artificial Intelligence and a PhD in Computational Neuroscience along the way.


**What are you passionate about?**

I feel strongly that researchers have a responsibility to ensure that the outcomes of their research are made available to all - researchers, practitioners and the public.
These outcomes should be made available in a way that allows others not just to reproduce them, but also to re-use and build upon them.

An awful lot of researcher and practitioner time is spent getting to the point they can usefully evaluate whether some research is of use to them, or in re-discovering unpublished negative results.
This seems extremely wasteful and I'm convinced we can and should do better.
In particular, I feel a lot can be done to improve the effective re-use of data produced by research projects.
While there has been significant progress in recent years in the amount of data published alongside research articles, there is still a wide gulf between open data and re-usable data.

In terms of research areas, I'm fascinated by the brain and especially the approach of understanding the brain by "faking it" (i.e. modelling and simulation).
I'm particularly interested in robots as a way of embodying these models in the real world.

**Why do you care about the Turing Way?**

I want to live in a world where the norm is that researchers are sharing their research outcomes in sufficient detail to permit reproduction, re-use and extension by others.
In order for this to happen I think we need both a change in community norms and an improvement to researchers' working practices.
I believe the Turing Way can impact positively in both these areas.
By providing recommended working practices and guidance on associated tooling, we can make it easy for researchers to do the right thing.
By publishing this with the weight of the Turing brand, we can apply social pressure for the adoption of these practices as new norms in the research communities we operate in.


### Anna Krystalli

**Who are you?**

I’m a Research Software Engineer at the University of Sheffield helping researchers do more with their code and data. I’m also an editor for rOpenSci, a community of users and developers, Creating technical infrastructure of peer-reviewed R software tools for working with scientific data sources on the web.


**What are you passionate about?**

Reproducible research in R!

I learnt to code during my PhD in Marine Macroecology and was instantly hooked. Building on past experience as a quality assurance auditor, my experiences made me interested in how we practice science and specifically how we can do more out of the real workhorses of modern research, our code and data. 

I’m excited about both the opportunities and challenges of next generation open science and how we can build on tools, conventions and practices from the rich and constantly evolving open source ecosystem.


**Why do you care about the Turing Way?**

This is a fantastic opportunity to take stock of the great work that has already been done in this space, aggregate and distill it to templates, checklists and  best practices guidelines that are immediately useful to researchers.  It’s an opportunity to set standards and harness the power of convention, especially with ECRs that have an opportunity to set up good practices from the start! Indeed, I hope the Turing Way will very much become the “Sheffield Way” too!


### Sarah Gibson

**Who are you?**

I'm a new Data Scientist in the Research Engineering team - still exploring what that means on new projects such as the Turing Way! I completed my PhD in Astrophysics at the University of Leicester this year.

**What are you passionate about?**

I'm passionate about applying the skills I learnt during my PhD somewhere closer to home and learning new skills along the way. I'm also a big music fan.

**Why do you care about the Turing Way?**

The Turing Way is an ideal opportunity for me to learn better research practices and widen my horizons from what academia has taught me.


### Louise Bowler

**Who are you?**

I'm a Research Data Scientist in the Alan Turing Institute's Research Engineering Group. I have a degree in Physics from Imperial College London, after which I joined the Life Sciences Interface Doctoral Training Centre at the University of Oxford. My doctoral work at Oxford was highly interdisciplinary, combining mathematical modelling, cardiac electrophysiology and safety pharmacology.

**What are you passionate about?**

As scientists, we share our work via papers and talks, but the intricacies of precisely *how* we implement an analysis pipeline or novel algorithm can be very difficult to convey in those formats. We're currently seeing changes in the default way we want to publish our papers through the open access movement, and I'd love to see a similar change in mindset happen about the data that we collect and the code that we develop so that others can reproduce, learn from and build upon our work. I want to ensure that the route to sharing these types of research output is open to everyone, regardless of their level of programming experience - the route might not always be straightforward, but it's a great opportunity to share and learn from our experiences!

**Why do you care about the Turing Way?**

So many research projects now contain computational elements, yet it is easy to forget that not everyone has access to training in software engineering, or has a group of colleagues with such interests. If we say that we want people to make their research open and reproducible, we need to give them the tools they need to be confident in doing so. I see the Turing Way as the means of bridging that gap, by providing a friendly, practical and helpful guide for researchers at all stages of their careers.


### Rosie Higman

**Who are you?**

I am a Research Data Librarian at the University of Manchester, co-leading the research data management support service. My focus is on data sharing, training and encouraging researchers to engage in Open Research. 

My background is in the social sciences and I have recently started a PhD with the British Library and the University of Sheffield looking at Open Access and the role of the National Library. 

**What are you passionate about?**

Supporting researchers! Making it as easy as possible for researchers to make their research reproducible and open, and for this to be easier than undertaking reserach in a closed manner. I try to help researchers make small improvements in making their research open, on the basis that some progress is better than none!

Working in research data management I'm naturally concerned that data is not taken seriously as an independent research output and the reward system in academia is so heavily geared towards 'high impact' journal articles. As someone from a non-STEM background I'm also interested in how we can make reproducible research as accessible as possible. This will be the first project where I've worked directly in GitHub and I'm excited to get more confident in using it!

**Why do you care about the Turing Way?**

I spend much of my time talking to researchers about the overarching principles of *why* reproducible and open research is a good idea and am excited by the idea of giving people practical guidance on *how* to do this. Messy code is frequently cited in these discussions as a reason for not sharing code so if we could produce something which helps people get past this barrier would be great. I hope that the Turing Way will be something we can also use at the University of Manchester and other Turing universities around the country! 


### Rachael Ainsworth

**Who are you?**

I am a Research Associate and Open Science Champion at the Jodrell Bank Centre for Astrophysics at the University of Manchester. My research involves observing jets from young stars with next-generation radio telescopes to investigate the physical processes that assemble stars like our Sun, and am currently working to make data from the radio telescope facilities at Jodrell Bank more accessible to all. I am also a FOSTER certified Open Science Trainer, Mozilla Open Leader, Organiser for the women in data meetup group HER+Data MCR and member of the first cohort of Tech Future Female Leaders. 

**What are you passionate about?**

I am passionate about promoting openness, transparency, reproducibility, wellbeing and inclusion in STEM and facilitating cross-stakeholder conversations in order to change research culture for the better. I also love space exploration.

**Why do you care about the Turing Way?**

The Turing Way goal of ensuring that reproducible data science is "too easy not to do" really resonates with me. I find that it can be difficult to get researchers to engage with reproducibility and sharing their research outputs because they perceive that it will take too much time and effort with very little reward - when the opposite is true! Ensuring results are reproducible not only benefits research as a whole and increases efficiency, but working this way also offers researchers more opportunities for impact and collaboration.
