# LIBER 2019 Conference
> LIBER (Ligue des Bibliothèques Européennes de Recherche) is the Association of European Research Libraries

## Is this the way to reproducibility?

## Authors
The Turing Way (3), Patricia Herterich (1; presenting author), Rosie Higman (2; presenting author)   
1 University of Birmingham, United Kingdom;  
2 University of Manchester, United Kingdom;  
3 The Alan Turing Institute, United Kingdom;  

## Abstract

Reproducible research is necessary to ensure that scientific work can be trusted. 
In addition to making publications available open access, funders and publishers are beginning to require that publications include access to the underlying data and the analysis code. 
The goal is to ensure that all results can be independently verified and built upon in future work, make research transparent for the benefit of the wider society and regain trust in research results.  
This is sometimes easier said than done. Sharing data and code requires understanding of data management, library sciences, software development, and continuous integration techniques: skills that are not widely taught or expected of academic researchers and data scientists. 
Likewise, research data librarians can only provide support with some aspects of a reproducible research process, typically focusing on data management and sharing. Whilst reproducibility is slowly becoming more of a focus for research data librarians in the US, examples of similar posts in Europe are lacking (Sayre & Riegelman, 2018, Steeves, 2017). 
One of the key responsibilities of a “reproducibility librarian” will be establishing collaborations with a variety of stakeholders, to ensure they can point academics to resources covering reproducible practices throughout the full research life cycle.  
The talk will introduce “The Turing Way” project, a 5 month project led by the Alan Turing Institute to bring together research software engineers and research data librarians in order to write a handbook to support students, their supervisors, funders and journal editors in ensuring that reproducible data science is “too easy not to do”. 
We will present the first release of the resource created as well as the process of developing a handbook in an open and transparent collaboration between librarians, research software engineers and researchers on GitHub (https://github.com/alan-turing-institute/the-turing-way/). 
The talk will reflect on the collaboration and how lessons learnt can help research data librarians gain skills and networks to provide holistic open science support in the future and stake their claim in supporting reproducibility.

Sayre, F., & Riegelman, A. (2018). The reproducibility crisis and academic libraries. College & Research Libraries, 79(1), 2. https://doi.org/10.5860/crl.79.1.2

Steeves, V. (2017). Reproducibility librarianship. Collaborative Librarianship, 9(2), 4. Available at: https://digitalcommons.du.edu/collaborativelibrarianship/vol9/iss2/4

## Submission info
* Website: https://liberconference.eu
* Application form: https://liberconference.eu/liber-2019-call-for-papers  
* Location: Dublin, Ireland
* Date: 26 - 28 June 2019
* ID: 189  
* Type: Paper (standard presentation)  
* Topics: Open Science, including Open Access  
* Keywords: Research Data Management, Open Science, Reproducibility, Data Librarianship  
* Submitted on 14/01/2019
