# The Turing Way - February update

Dear friends of the Turing Way,

It's been almost a month since we announced the project and we've made great progress since then that we think you should know about.

## Workshops
We still have spots available for our workshops in March. 
We can provide financial support to cover travel, accommodation or childcare costs to make it easier for you to attend. 
Please get in touch at theturingway@gmail.com to let us know how we can support you.
We start at 10am with coffee from 9:30am and finish at 4pm.
You're welcome to hang out for an extra hour until 5pm but we'll officially finish at 4pm so that anyone with childcare responsibilities can get home!

### Boost your reproducibility with binder

During this free workshop we will discuss reproducible computing environments, show examples of others’ projects in myBinder.org and help you learn how to prepare a binder-ready project. 
At the end of the workshop you will be able to take some of your own content (in a R or Jupyter notebook, or scripts that can be run in the terminal) and prepare it so that it can be used by others on myBinder.org.

**Agenda**

* 9.30 - 10.00: Registration, coffee and introductions
* 10.00 - 10.30: Introduction to the workshop and The Turing Way
* 10.30 - 12.00: Why you need a reproducible computing environment and how Binder can help
* 12.00 - 1.00: Lunch
* 1.00 - 2.00: Zero to Binder, a guided tour of building a Binder resource
* 2.00 - 3.30: Build your own Binder (with coffee from 2.00)
* 3.30 - 4.00: Demonstrating your Binder, general questions, feedback and close
* 4.00 - 5.00: Optional hangout with instructors

**Workshop locations and sign-up**
* [Manchester - 1st March](https://www.eventbrite.co.uk/e/boost-your-research-reproducibility-with-binder-manchester-registration-55331997494)
* [London - 12th March](https://www.eventbrite.co.uk/e/boost-your-research-reproducibility-with-binder-london-registration-55337162944)

### Build a BinderHub workshop

During this free workshop we will demonstrate how to build your own BinderHub on Microsoft Azure cloud computing resources. 
We will help you get started with building a BinderHub on your institution's computing platform and discuss the challenges of maintaining a BinderHub. 
At the end of the workshop you will know why this would be a useful resource for your team, and will know where to look for help and support building your institution's BinderHub.

* 9.30 - 10.00: Registration, coffee and introductions
* 10.00 - 10.30: Introduction to the workshop and The Turing Way
* 10.30 - 11.00: Introduction to Binder and why *you* should build a BinderHub
* 11.00 - 12.00: Practical session – Build a BinderHub
* 12.00 - 1.00: Lunch
* 1.00 - 2.45: Practical session – Build a BinderHub
* 2.45 - 3.00: Coffee
* 3.00 - 4.00: Looking forwards: Progress review, lessons learned and future strategies
* 4.00 - 5.00: Optional hangout with instructors

**Workshop location and sign-up**
* [Sheffield - 18th March](https://www.eventbrite.co.uk/e/build-a-binderhub-registration-55336756729)

## Handbook

Three chapters are written and ready for your comments! 
[Version Control](https://github.com/alan-turing-institute/the-turing-way/blob/master/chapters/version_control.md), [Reproducibility](https://github.com/alan-turing-institute/the-turing-way/blob/master/chapters/reproducibility.md) and [Open Research](https://github.com/alan-turing-institute/the-turing-way/blob/master/chapters/open_research.md) are ready for feedback.  
We're currently working on the chapters on Research Data Management, Reproducible Computing Environments, Testing, and Continuous Integration. 
You can follow the progress through the [pull requests on our GitHub repsoitory](https://github.com/alan-turing-institute/the-turing-way/pulls): [#146](https://github.com/alan-turing-institute/the-turing-way/pull/146), [#147](https://github.com/alan-turing-institute/the-turing-way/pull/147) & [#148](https://github.com/alan-turing-institute/the-turing-way/pull/148).  
We're still building up our [contributing guidelines](https://github.com/alan-turing-institute/the-turing-way) to make sure it's easy for you to feed back and add your knowledge to the Turing Way. 
In the meantime, creating an issue on [GitHub](https://github.com/alan-turing-institute/the-turing-way/issues) or pinging us on [our gitter channel](https://gitter.im/alan-turing-institute/the-turing-way) is always a good start!

## Talks
The team has been spreading the word about the Turing Way project through various talks:
* Kirstie Whitaker presented at the Cambridge Psychiatry PI Day on 30 January 2019. 
Her slides can be found on [figshare](https://doi.org/10.6084/m9.figshare.7649156).
* Sarah Gibson presented at the [UKRI Cloud workshop](https://cloud.ac.uk/workshops/feb2019/). 
Resources for her talk can be found [here](https://github.com/alan-turing-institute/the-turing-way/blob/master/conferences/presentations/UKRI_cloud_2019-02-12/UKRI_cloud_demo_2019-02-12.md).
* Patricia Herterich introduced the Turing Way to the Birmingham Hacker Within community on 18 February 2019. 
Slides for her talk are published on [zenodo](http://doi.org/10.5281/zenodo.2566430).

## Where to meet us in the next weeks

If you can't make it to one of our workshops - we will attend a few other other events around the UK where you can chat to us in person.

* Kirstie will be at the [Turing Lecture: Open source influences on technology innovation](https://www.turing.ac.uk/events/turing-lecture-open-source-influences-technology-innovation) at The Royal Society of Medicine, London on 27 February 2019.
  There are still tickets available if you'd like to come!

* Most of the Turing Way team will be at the [Software Sustainability Insitute's Collaborations Workshop](https://www.software.ac.uk/cw19) in Loughborough 1 - 3 April 2019. We hope to see many of you there for [the launch demo](https://software.ac.uk/blog/2019-02-21-inspiring-demos-are-waiting-you-collaborations-workshop-2019) of our handbook!


We would still love you to share your tips, tricks and gotchas with the Turing Way community!
To add your advice to the handbook, please fill out our quick [submission form](https://goo.gl/forms/akFqZEIy2kxAjfZW2).

Thank you for reading, and we look forward to your contributions!

The Turing Way project team  
https://github.com/alan-turing-institute/the-turing-way
