# The Turing Way
[![Join the chat at https://gitter.im/alan-turing-institute/the-turing-way](https://badges.gitter.im/alan-turing-institute/the-turing-way.svg?style=flat-square)](https://gitter.im/alan-turing-institute/the-turing-way) [![Join our tinyletter mailing list](https://img.shields.io/badge/receive-our%20newsletter%20❤%EF%B8%8F-blueviolet.svg?style=flat-square)](https://tinyletter.com/TuringWay) [![All Contributors](https://img.shields.io/badge/all_contributors-13-orange.svg?style=flat-square)](#contributors) [![Read the book](https://img.shields.io/badge/read-the%20book-blue.svg)](https://github.com/alan-turing-institute/the-turing-way-book)

The Turing Way is a lightly opinionated guide to reproducible data science.

Our goal is to provide all the information that researchers need at the start of their projects to ensure that they are easy to reproduce at the end.

This also means making sure PhD students, postdocs, PIs and funding teams know which parts of the "responsibility of reproducibility" they can affect, and what they should do to nudge data science to being more efficient, effective and understandable.

Table of contents:
* [About the project](#about-the-project)
* [Contributing](#contributing)
* [Get in touch](#get-in-touch)

### About the project

Reproducible research is necessary to ensure that scientific work can be trusted.
Funders and publishers are beginning to require that publications include access to the underlying data and the analysis code.
The goal is to ensure that all results can be independently verified and built upon in future work.
This is sometimes easier said than done.
Sharing these research outputs means understanding data management, library sciences, sofware development, and continuous integration techniques: skills that are not widely taught or expected of academic researchers and data scientists.
*The Turing Way* is a handbook to support students, their supervisors, funders and journal editors in ensuring that reproducible data science is "too easy not to do".
It will include training material on version control, analysis testing, and open and transparent communication with future users, and build on Turing Institute case studies and workshops.
This project is openly developed and any and all questions, comments and recommendations are welcome at our github repository: https://github.com/alan-turing-institute/the-turing-way.

To manage this repository better, we moved the book content to a separate repository: https://github.com/alan-turing-institute/the-turing-way-book

### The team

This is the (part of) the project team planning work at the Turing Institute. For more on how to contact us, see the [ways of working document](ways_of_working.md).

![Team photo](/figures/TuringWayTeam.jpg)


### Contributing 

:construction: This repository is always a work in progress and **everyone** is encouraged to help us build something that is useful to the many. :construction:

Everyone is asked to follow our [code of conduct](CODE_OF_CONDUCT.md) and to checkout our [contributing guidelines](CONTRIBUTING.md) for more information on how to get started.

If you are not familiar or confident contributing on GitHub, you can also contribute a case study and your tips and tricks via our [Google submission form](https://goo.gl/forms/akFqZEIy2kxAjfZW2). 

### Get in touch

We have a gitter chat room and we'd love for you to swing by to say hello at https://gitter.im/alan-turing-institute/the-turing-way.

We also have a tiny letter mailing list to which we send monthly project updates.
Subscribe at https://tinyletter.com/TuringWay.

You can contact the PI of the Turing Way project - Kirstie Whitaker - by email at [kwhitaker@turing.ac.uk](mailto:kwhitaker@turing.ac.uk).


## Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/all-contributors/all-contributors#emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore -->
| [<img src="https://avatars1.githubusercontent.com/u/20441134?v=4" width="100px;" alt="Becky Arnold"/><br /><sub><b>Becky Arnold</b></sub>](https://github.com/r-j-arnold)<br />[💬](#question-r-j-arnold "Answering Questions") [💻](https://github.com/alan-turing-institute/the-turing-way/commits?author=r-j-arnold "Code") [📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=r-j-arnold "Documentation") [🤔](#ideas-r-j-arnold "Ideas, Planning, & Feedback") [👀](#review-r-j-arnold "Reviewed Pull Requests") | [<img src="https://avatars1.githubusercontent.com/u/25640708?v=4" width="100px;" alt="Louise Bowler"/><br /><sub><b>Louise Bowler</b></sub>](https://github.com/LouiseABowler)<br />[💬](#question-LouiseABowler "Answering Questions") [💻](https://github.com/alan-turing-institute/the-turing-way/commits?author=LouiseABowler "Code") [📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=LouiseABowler "Documentation") [💡](#example-LouiseABowler "Examples") [🤔](#ideas-LouiseABowler "Ideas, Planning, & Feedback") [📋](#eventOrganizing-LouiseABowler "Event Organizing") [👀](#review-LouiseABowler "Reviewed Pull Requests") | [<img src="https://avatars3.githubusercontent.com/u/20327215?v=4" width="100px;" alt="Jason M. Gates"/><br /><sub><b>Jason M. Gates</b></sub>](https://github.com/jmgate)<br />[📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=jmgate "Documentation") [👀](#review-jmgate "Reviewed Pull Requests") | [<img src="https://avatars2.githubusercontent.com/u/44771837?v=4" width="100px;" alt="sgibson91"/><br /><sub><b>sgibson91</b></sub>](https://github.com/sgibson91)<br />[💬](#question-sgibson91 "Answering Questions") [💻](https://github.com/alan-turing-institute/the-turing-way/commits?author=sgibson91 "Code") [📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=sgibson91 "Documentation") [🔧](#tool-sgibson91 "Tools") [👀](#review-sgibson91 "Reviewed Pull Requests") [📢](#talk-sgibson91 "Talks") [🤔](#ideas-sgibson91 "Ideas, Planning, & Feedback") [✅](#tutorial-sgibson91 "Tutorials") | [<img src="https://avatars1.githubusercontent.com/u/1448859?v=4" width="100px;" alt="Tim Head"/><br /><sub><b>Tim Head</b></sub>](https://github.com/betatim)<br />[💬](#question-betatim "Answering Questions") [🤔](#ideas-betatim "Ideas, Planning, & Feedback") | [<img src="https://avatars0.githubusercontent.com/u/8457675?v=4" width="100px;" alt="Patricia Herterich"/><br /><sub><b>Patricia Herterich</b></sub>](https://github.com/pherterich)<br />[💬](#question-pherterich "Answering Questions") [📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=pherterich "Documentation") [👀](#review-pherterich "Reviewed Pull Requests") [🤔](#ideas-pherterich "Ideas, Planning, & Feedback") [🖋](#content-pherterich "Content") | [<img src="https://avatars2.githubusercontent.com/u/15738325?v=4" width="100px;" alt="Rosie Higman"/><br /><sub><b>Rosie Higman</b></sub>](https://github.com/rosiehigman)<br />[💬](#question-rosiehigman "Answering Questions") [📋](#eventOrganizing-rosiehigman "Event Organizing") [👀](#review-rosiehigman "Reviewed Pull Requests") [🤔](#ideas-rosiehigman "Ideas, Planning, & Feedback") |
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| [<img src="https://avatars1.githubusercontent.com/u/5583057?v=4" width="100px;" alt="Anna Krystalli"/><br /><sub><b>Anna Krystalli</b></sub>](https://www.annakrystalli.me/)<br />[💬](#question-annakrystalli "Answering Questions") [💡](#example-annakrystalli "Examples") [👀](#review-annakrystalli "Reviewed Pull Requests") [🤔](#ideas-annakrystalli "Ideas, Planning, & Feedback") | [<img src="https://avatars2.githubusercontent.com/u/13655521?v=4" width="100px;" alt="Alexander Morley"/><br /><sub><b>Alexander Morley</b></sub>](http://alexmorley.me)<br />[💬](#question-alexmorley "Answering Questions") [👀](#review-alexmorley "Reviewed Pull Requests") [🤔](#ideas-alexmorley "Ideas, Planning, & Feedback") [⚠️](https://github.com/alan-turing-institute/the-turing-way/commits?author=alexmorley "Tests") | [<img src="https://avatars3.githubusercontent.com/u/21147592?v=4" width="100px;" alt="Martin O'Reilly"/><br /><sub><b>Martin O'Reilly</b></sub>](https://github.com/martintoreilly)<br />[💬](#question-martintoreilly "Answering Questions") [🔧](#tool-martintoreilly "Tools") [🤔](#ideas-martintoreilly "Ideas, Planning, & Feedback") | [<img src="https://avatars1.githubusercontent.com/u/5434836?v=4" width="100px;" alt="Oliver Strickson"/><br /><sub><b>Oliver Strickson</b></sub>](https://github.com/ots22)<br />[💬](#question-ots22 "Answering Questions") [📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=ots22 "Documentation") | [<img src="https://avatars1.githubusercontent.com/u/3626306?v=4" width="100px;" alt="Kirstie Whitaker"/><br /><sub><b>Kirstie Whitaker</b></sub>](https://whitakerlab.github.io)<br />[💬](#question-KirstieJane "Answering Questions") [📖](https://github.com/alan-turing-institute/the-turing-way/commits?author=KirstieJane "Documentation") [🎨](#design-KirstieJane "Design") [📋](#eventOrganizing-KirstieJane "Event Organizing") [🔍](#fundingFinding-KirstieJane "Funding Finding") [🤔](#ideas-KirstieJane "Ideas, Planning, & Feedback") [👀](#review-KirstieJane "Reviewed Pull Requests") [📢](#talk-KirstieJane "Talks") | [<img src="https://avatars1.githubusercontent.com/u/1839645?v=4" width="100px;" alt="Chris Holdgraf"/><br /><sub><b>Chris Holdgraf</b></sub>](http://chrisholdgraf.com)<br />[💬](#question-choldgraf "Answering Questions") [🤔](#ideas-choldgraf "Ideas, Planning, & Feedback") |
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
