# Contributing to the Turing Way

:tada::balloon::cake: **Welcome to the Turing Way repository!** :cake::balloon::tada:

:dizzy::hatched_chick::sunny: *We're so excited you're here and want to contribute.* :sunny::hatched_chick::dizzy:

The point of this starter kit is to **welcome new users and contributors to the Turing Way community**. We hope that these guidelines are designed to make it as easy as possible to get involved. Don't let trying to be perfect get in the way of being good - we welcome all contributions and would love it if you could follow these guidelines to make sure your contributions can easily integrated but exiting ideas are more important than perfect pull requests. :heart:
<br>
If you have any questions that aren't discussed below, please let us know through one of the many ways to [get in touch](#get-in-touch).

## Table of contents

Been here before? Already know what you're looking for in this guide? Jump to the following sections:

* [Joining the community](#joining-the-community)
* [Inclusivity](#inclusivity)
* [Get in touch](#get-in-touch)
* [Contributing through GitHub](#contributing-through-github)
* [Where to start: issues](#where-to-start-issues)
* [Making a change with a pull request](#making-a-change-with-a-pull-request)
* [Become a maintainer](#become-a-maintainer)
* [The process of writing chapters](#the-process-of-writing-chapters)

## Joining the community

The Turing Way community We therefore require that all contributions **adhere to our [Code of Conduct](CODE_OF_CONDUCT.md)**.

## Inclusivity

This project aims to be inclusive to people from all walks of life and to all research fields.
This should be taken into account in contributions.

The following are examples of inclusive actions that we encourage from contributors to the Turing Way:

* Refer to "open research" rather than "open science" so that we do not exclude members of the humanities and social sciences from our community.
* Make sure colour pallettes are accessible to colour-blind readers and contributors.
  Here's a useful blog post on [tips for designing scientific figures for color blind readers](http://www.somersault1824.com/tips-for-designing-scientific-figures-for-color-blind-readers) by Luk at [Somersulat 1824](http://www.somersault1824.com).

## Get in touch

Ping us in our [gitter channel](https://gitter.im/alan-turing-institute/the-turing-way).\
You can also contact the PI of the Turing Way project - Kirstie Whitaker - by email at kwhitaker@turing.ac.uk.

## Contributing through GitHub

[git][git] is a really useful tool for version control. [GitHub][github] sits on top of git and supports collaborative and distributed working.

We know that it can be daunting to start using git and GitHub if you haven't worked with them in the past, but the The Turing Way maintainers are here to help you figure out any of the jargon or confusing instructions you encounter! :heart:

In order to contribute via GitHub you'll need to set up a free account and sign in. Here are some [instructions](https://help.github.com/articles/signing-up-for-a-new-github-account/) to help you get going. Remember that you can ask us any questions you need to along the way.

## Writing in Markdown

GitHub has a helpful page on [getting started with writing and formatting on GitHub](https://help.github.com/articles/getting-started-with-writing-and-formatting-on-github).

Most of the writing that you'll do will be in [Markdown][markdown]. You can think of Markdown as a few little symbols around your text that will allow GitHub to render the text with a little bit of formatting. For example you could write words as **bold** (`**bold**`), or in *italics* (`*italics*`), or as a [link][rick-roll] (`[link](https://https://youtu.be/dQw4w9WgXcQ)`) to another webpage.
Also when writing in Markdown, please start each new sentence on a new line.
While this formats in the same way as if the new line wasn't included, it makes the diffs produced during the pull request review easier to read! :sparkles:

## Where to start: issues

Before you open a new issue, please check if any of the open issues covers your idea already. If you open a new issue, please follow our basic guidelines laid out in our [issue template][issue-template].

### Issue labels

The list of labels for current issues can be found [here][turing-way-labels] and includes:

* [![help-wanted](https://img.shields.io/badge/-help%20wanted-159818.svg)][labels-helpwanted] *These issues contain a task that a member of the team has determined we need additional help with.*

    If you feel that you can contribute to one of these issues, we especially encourage you to do so!

* [![question](https://img.shields.io/badge/-question-cc317c.svg)][labels-question] *These issues contain a question that you'd like to have answered.*

    There are [lots of ways to ask questions](#get-in-touch) but opening an issue is a great way to start a conversation and get your answer.

* [![good-first-issue](https://img.shields.io/badge/-good%20first%20issue-1b3487.svg)][labels-firstissue] *These issues are particularly appropriate if it is your first contribution to the Turing Way, or to GitHub overall.*

    If you're not sure about how to go about contributing, these are good places to start. You'll be mentored through the process by the maintainers team. If you're a seasoned contributor, please select a different issue to work from and keep these available for the newer and potentially more anxious team members.

* [![Enhancement](https://img.shields.io/badge/-enhancement-84b6eb.svg)][labels-enhancement] *These issues are suggesting new features that can be added to the project.*

    If you want to ask for something new, please try to make sure that your request is distinct from any others that are already in the queue (or part of the Turing Way). If you find one that's similar but there are subtle differences please reference the other enhancement in your issue.

* [![Community](https://img.shields.io/badge/-community-8605c1.svg)][labels-community] *These issues relate to building and supporting the Turing Way community.*

 This is all about collaborating, so please let us know how we can best support you as a community member.

* [![Bug](https://img.shields.io/badge/-bug-d73a4a.svg)][labels-bug] *These issues are reporting a problem or a mistake in the project.*

    The more details you can provide the better! If you know how to fix the bug, please open an issue first and then submit a pull request :sparkles:

* [![Book](https://img.shields.io/badge/-book-c5bcff.svg)][labels-book] *These issues cover everything around the process of writing the book.*

* [![workshops](https://img.shields.io/badge/-workshops-c1663c.svg)][labels-workshops] *These issues help us organise our workshops.*

* [![project-management](https://img.shields.io/badge/-project%20management-bfd86c.svg)][labels-project-management] *We like to model best practice, so the Turing Way itself is managed through these issues. These issues help us to coordinate some logistics.*

* [![jupyter](https://img.shields.io/badge/-jupyter-F37726.svg)][labels-jupyter] *Everything related to building a BinderHub*

* [![Tools](https://img.shields.io/badge/-tools-a3e07d.svg)][labels-tools] *These issues discuss tools we use for collaboration*

If you feel that we should try new tools or some aspects of the collaboration could be improved by using tools, please let us know.

* [![Travel](https://img.shields.io/badge/-travel-0f42fc.svg)][labels-travel] *These issues are mainly for the attention of core project members to plan travel to face to face meetings*

* [![Comms](https://img.shields.io/badge/-comms-15c4b2.svg)][labels-comms] *These issues discuss how we as a project interact with other initiatives.*



## Making a change with a pull request
> Needs to cover:
> - Open pull requests early
> - Use the WIP marker if you're not ready for the review
> - You can submit pull requests to the OTHER PERSON'S BRANCH.
> - All the branch and fork and sync stuff that I kind of understand but cannot explain
> - Commit often
> - Write good commit messages

## The process of writing chapters

- Fork the repository form the alan turing version if you have not done so already.
- On the alan turing version create a branch with the same name as the chapter to be written.
- On your fork create a branch with the same name and create a markdown file on it.
- Copy the chapter template in the templates directory into the markdown file, and commit.
- Make a pull request to the turing way version of the chapter branch.
The title of this request should have the form "[WIP] Write Chapter_name chapter".
WIP indicates the chapter is a Work In Progress and not yet ready for review.
- On your branch add material to the chapter and commit.
The goal of this project is to collate and build on the many good resources already available about good practise in data science.
As such this material should primarily be drawn from outside sources.
Note the link and (if available) license of the source.
- Once a significant amount of material has been amassed, work (preferably with others) to develop a chapter outline.
- Edit the amassed material into a coherent chapter, adding more material if gaps become apparent.
- Edit the chapter for style.
- Once the first draft of the chapter is complete change [WIP] in the pull request title to [Ready for review].
- Add a comment on the pull request indicating that this chapter is ready for high level review, i.e discussion of changes of scale of a paragraph or larger such as adding material and restructuring sections.
- Discuss and make these high level changes on this pull request. Once this is complete merge the chapter into the alan turing intitute's version of the chapter branch.
- Make another pull request from your fork's version of the branch to the alan turing institute's version of the branch. Title this "[Ready for review] Chapter_name chapter- low level reviews".
- Discuss and make low level changes to the chapter on this pull request, such as rewording sentences, typos and the like.
- This division of the pull requests into high and low level changes stops discussion threads becoming unmanagably long.
- Once this is complete merge the pull request into the alan turing intitute's version of the chapter branch.
- Merge the alan turing intitute's version of the chapter branch into the alan turing master branch.
DO not delete the branch as the chapter may continue to undergo improvement and development in the future.



[git]: https://git-scm.com
[github]: https://github.com
[issue-template]: https://github.com/alan-turing-institute/the-turing-way/blob/master/ISSUE_TEMPLATE.md
[labels-link]: https://github.com/alan-turing-institute/the-turing-way/labels
[labels-book]: https://github.com/alan-turing-institute/the-turing-way/labels/book
[labels-bug]: https://github.com/alan-turing-institute/the-turing-way/labels/bug
[labels-community]: https://github.com/alan-turing-institute/the-turing-way/labels/community
[labels-comms]: https://github.com/alan-turing-institute/the-turing-way/labels/comms
[labels-enhancement]: https://github.com/alan-turing-institute/the-turing-way/labels/enhancement
[labels-firstissue]: https://github.com/alan-turing-institute/the-turing-way/labels/good%20first%20issue
[labels-helpwanted]: https://github.com/alan-turing-institute/the-turing-way/labels/help%20wanted
[labels-jupyter]: https://github.com/alan-turing-institute/the-turing-way/labels/jupyter
[labels-project-management]: https://github.com/alan-turing-institute/the-turing-way/labels/project%20management
[labels-question]: https://github.com/alan-turing-institute/the-turing-way/labels/question
[labels-tools]: https://github.com/alan-turing-institute/the-turing-way/labels/tools
[labels-travel]: https://github.com/alan-turing-institute/the-turing-way/labels/travel
[labels-workshops]: https://github.com/alan-turing-institute/the-turing-way/labels/workshops
[markdown]: https://daringfireball.net/projects/markdown
[rick-roll]: https://www.youtube.com/watch?v=dQw4w9WgXcQ
[turing-way-labels]: https://github.com/alan-turing-institute/the-turing-way/labels
