# Binder workshops lead by the Turing Way Team

There are two types of workshop:
* [Boost your research reproducibility with Binder](../boost-research-reproducibility-binder/workshop_advert.md)
  * Aimed at researchers who want to share their analyses.
* [Build a BinderHub](#build-a-binderhub)
  * Aimed at research software engineers or IT staff who want to host a BinderHub to support their research communities.

This file contains the text that will be used to promote the BinderHub workshop in Sheffield on Monday 18th March 2019.

## Build a BinderHub

Funders and publishers are beginning to require that publications include access to the underlying data and the analysis code.
Researchers can be supported in doing this through [myBinder.org](https://mybinder.org/) which allows you to share your software with others in the form of a single clickable link, making it easier for users and removing the need for you to worry about supporting lots of different platforms.
This is a huge step forward in terms of supporting reproducibility but the public Binder instance, [myBinder.org](https://mybinder.org/), requires all code and data to be fully open, and computational power and data storage is limited.
One solution to this is to host your own [BinderHub](https://binderhub.readthedocs.io/en/latest/) locally, allowing you to control who has access to code and data and to provide greater computational power.

During this free workshop we will demonstrate how to build your own BinderHub on Microsoft Azure cloud computing resources.
We will help you get started with building a BinderHub on your institution's computing platform and discuss the challenges of maintaining a BinderHub.
At the end of the workshop you will know why this would be a useful resource for your team, and will know where to look for help and support building your institution's BinderHub.

This workshop is for Research Software Engineers and IT staff who are:
*	Interested in reproducibility, containers, Docker or continuous integration;
*	Already familiar with Binder and R Markdown or Python for data science;
*	Interested in setting up their own local BinderHub.

### The Turing Way

This workshop is being run by The Turing Way project team.
The Turing Way is a handbook to support students, their supervisors, funders and journal editors in ensuring that reproducible data science is "too easy not to do".
It is openly developed and any and all questions, comments and recommendations are welcome at our github repository: https://github.com/alan-turing-institute/the-turing-way or in our [gitter chat room](https://gitter.im/alan-turing-institute/the-turing-way).
Our interdisciplinary team includes data scientists, research software engineers and librarians.
We are all motivated to ensure that all results can be independently verified and built upon in future work and want to help as many people learn the skills and tools required to do so.
We hope that workshop participants will also contribute their "tips and tricks" on using Binder to the book to share what they've learned with others.

### Programme

* 9.30 - 10.00: Registration, coffee and introductions
* 10.00 - 10.30: Introduction to the workshop and The Turing Way
* 10.30 - 11.00: Introduction to Binder and why *you* should build a BinderHub
* 11.00 - 12.00: Practical session – Build your BinderHub
* 12.00 - 1.00: Lunch
* 1.00 - 2.45: Practical session – Build your BinderHub
* 2.45 - 3.00: Coffee
* 3.00 - 4.00: Looking forwards: Progress review, lessons learned and future strategies
* 4.00 - 5.00: Optional hangout with instructors

### Some example Binders:

*	[Office of National Statistics - a report on traffic flow as an early indicator for GDP](https://mybinder.org/v2/gh/ONSBigData/traffic_as_early_indicator/master?filepath=Report%20-%20Annual%20average%20daily%20traffic%20flow%20(AADF)%20as%20a%20correlate%20for%20GDP%20growth-Final.ipynb)
*	[A book on digital signal processing, or how computers understand music](https://mybinder.org/v2/gh/AllenDowney/ThinkDSP/master?filepath=code/cacophony.ipynb)
*	[A collection of notebooks about neural networks](https://mybinder.org/v2/gh/Calysto/conx/master?filepath=binder%2Findex.ipynb)
*	[Example of interactive code snippets in a normal webpage](https://spacy.io/usage/linguistic-features#pos-tagging)
