# Hack my BinderHub

Anna Krystalli, _University of Sheffield_

[**The Turing Way**](https://github.com/alan-turing-institute/the-turing-way) - making reproducible Data Science "too easy not to do"

***

## Welcome back!

✨ We hope you enjoyed experimenting with BinderHub this morning! ✨ 

We believe the ability to serve reproducible computation environments for analyses is a powerful approach to enabling reproducible research.

It's worth appreciating at this point that the opportunity to experiment with these techniques today comes from the fact that Binder is an **open source project** backed by an **active and welcoming community**. 

This has allowed to us to play around with the technology for free! It also means that it could (theoretically) disappear tomorrow.

**Our role as users is critical**

- innovation: propose new features and use cases
- robustness: finding bugs and usability issues
- documentation: find gaps and inconsistencies
- sustainability: adoption and dissemination

We've gathered valuable experience this morning from a wide range of perspectives. Now we want to **capture the insights gained as a contribution to the Binder project**

<img src="https://binderhub.readthedocs.io/en/latest/_static/logo.png" width=150>

***

## Making a contribution


We want try and capture any lessons learnt, problems identified or ideas generated through the morning sessions and discussions.

- **Overarching aim of any contribution should be to improve community understanding and project quality**
- Aim to work in groups around particular topics that have arisen.

- ‼️ **Before doing anything, do a quick check to make sure your idea hasn’t been discussed elsewhere** ‼️
    - Skim the project’s README, issues (open and closed) etc. 
    - A quick search for a few key terms goes a long way.
    - Feel free however to add to already existing discussions with new insight.


***

### Contribution types

There a number of options for contribution:

- Open an issue: 
    -
    A great starting point would be to open an issue with feedback on the topic you've chosen to work on. Follow any guidance in the issue template. 
    
- Make a pull request:
    - 
    If you feel confident enough, by all means feel free to make a direct contribution to materials associated with the project. Make sure to consult the [`CONTRIBUTING.md`](https://github.com/jupyterhub/binder/blob/master/CONTRIBUTING.rst) guidelines before you begin and to get ideas for useful contributions. 
    
- Start a Discussion:
    - 
    If your topic is more general or you'd like to start a broader community discussion, a good place to start would be the BinderHub discussion board in the Jupyter forum.
  
***

### Targets for contribution:

- **BinderHub [source code](https://github.com/jupyterhub/binderhub)** on GitHub

- **BinderHub/Binder documentation** source code in the project [`doc`](https://github.com/jupyterhub/binderhub/tree/master/doc) folder.
    - View public **BinderHub [documentation](https://binderhub.readthedocs.io/en/latest/)**
    - View public **Binder [documentation](https://mybinder.readthedocs.io/en/latest/)**
- **The BinderHub [discussion board](https://discourse.jupyter.org/c/binder/binderhub)** in the Jupyter forum.

- **The Turing Way *Build a Binderhub* [workshop materials](https://github.com/alan-turing-institute/the-turing-way/tree/master/workshops/build-a-binderhub)** (as a last resort)


***

### Contribution etiquette
#### Codes of Conduct

The starting point for any contribution to a community should be the community code of conduct.

- The Jupyter Project [Code of Conduct](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md)
- The Turing Way [Code of Conduct](https://github.com/alan-turing-institute/the-turing-way/blob/master/CODE_OF_CONDUCT.md)

<br>

#### Additional tips

- **Always show gratitude** for all the work that has been done so far.
- **Give context.** Help others get quickly up to speed. If you're dicussing code, provide a [minimal, complete, and verifiable example](https://stackoverflow.com/help/mcve). If you’re suggesting a new idea, explain why you think it’d be useful to the project 
- Aim of any **critique should be to improve community understanding and project quality**.
- **Start a conversation**:
    - It’s okay to ask questions (but be patient)
    - Engage with feedback
- **Do the homework:**
    - Show that you have engaged with problem
    - Show that you have grappled with appreciating project constraints
    - Preferable to provide solutions rather than problems.
- **Be explicit about what feedback you need**: e.g.
    -  discussion on the technical approach? 
    -  critique on a design proposal? 
    -  a review of copy?
- **Be concise**: Keep requests short and direct. It will increase the chance that someone will be able to help.
- **Respect community decisions**: Appreciate that our ideas may differ from the community’s priorities or vision. 
- **Above all, keep it classy.**
    >  Open source is made up of collaborators from all over the world. Context gets lost across languages, cultures, geographies, and time zones. In addition, written communication makes it harder to convey a tone or mood. Assume good intentions in these conversations. It’s fine to politely push back on an idea, ask for more context, or further clarify your position. Just try to leave the internet a better place than when you found it.

More detailed guidance can be found in the GitHub Open Source Guide Section: [_How to submit a contribution_](https://opensource.guide/how-to-contribute/#how-to-submit-a-contribution)

***

## Plan of Action

- #### Now: Topic & Group formation
    - Go through post-its and open discussion to identify themes and topics for contribution.
    - Get into groups around contribution topics.

- #### 14.00 Collaborative working
    - Group work on contribution.
    - 14.45 Coffee 
    - Group work and submission of contribution.
- #### 15.30: Regroup discussion: _Looking forwards_ (Lead by Becky Arnold)
    - Progress review
    - lessons learned 
    - future strategies
