# Binder workshops lead by the Turing Way Team

There are two types of workshop:
* [Boost your research reproducibility with Binder](#boost-your-research-reproducibility-with-binder)
  * Aimed at researchers who want to share their analyses.
* [Build a BinderHub](../build-a-binderhub/workshop_advert.md)
  * Aimed at research software engineers or IT staff who want to host a BinderHub to support their research communities.

This file contains the text that will be used to promote the Binder workshops in Manchester and London on Friday 1st and Tuesday 12th March 2019.

## Boost your research reproducibility with Binder

If you are looking for an easy way to share your code with others, without worrying about the computational environment they're running or installing a long list of requirements, then [Binder](https://mybinder.readthedocs.io/en/latest/) might be the solution for you.
Binder allows you to share your software with others in the form of a single clickable link, making it easier for users and removing the need for you to worry about supporting lots of different platforms.

During this free workshop we will discuss reproducible computing environments, show examples of others’ projects in [myBinder.org](https://mybinder.org/) and help you learn how to prepare a binder-ready project.
At the end of the workshop you will be able to take some of your own content (in a R or Jupyter notebook, or scripts that can be run in the terminal) and prepare it so that it can be used by others on myBinder.org.

This workshop is for people who are:
*	Interested in reproducibility, containers, Docker or continuous integration;
*	Already familiar with R Markdown or Jupyter notebooks;
*	Looking to communicate their research more effectively.

### The Turing Way

This workshop is being run by The Turing Way project team.
The Turing Way is a handbook to support students, their supervisors, funders and journal editors in ensuring that reproducible data science is "too easy not to do".
It is openly developed and any and all questions, comments and recommendations are welcome at our github repository: https://github.com/alan-turing-institute/the-turing-way or in our [gitter chat room](https://gitter.im/alan-turing-institute/the-turing-way).
Our interdisciplinary team includes data scientists, research software engineers and librarians.
We are all motivated to ensure that all results can be independently verified and built upon in future work and want to help as many people learn the skills and tools required to do so.
We hope that workshop participants will also contribute their "tips and tricks" on using Binder to the book to share what they've learned with others.

### Programme

* 9.30 - 10.00: Registration, coffee and introductions
* 10.00 - 10.30: Introduction to the workshop and The Turing Way
* 10.30 - 12.00: Why you need a reproducible computing environment and how Binder can help
* 12.00 - 1.00: Lunch
* 1.00 - 2.00: Zero to Binder, a guided tour of building a Binder resource
* 2.00 - 3.30: Build your own Binder (with coffee from 2.00)
* 3.30 - 4.00: Demonstrating your Binder, general questions, feedback and close
* 4.00 - 5.00: Optional hangout with instructors

### Some example Binders:

*	[Office of National Statistics - a report on traffic flow as an early indicator for GDP](https://mybinder.org/v2/gh/ONSBigData/traffic_as_early_indicator/master?filepath=Report%20-%20Annual%20average%20daily%20traffic%20flow%20(AADF)%20as%20a%20correlate%20for%20GDP%20growth-Final.ipynb)
*	[A book on digital signal processing, or how computers understand music](https://mybinder.org/v2/gh/AllenDowney/ThinkDSP/master?filepath=code/cacophony.ipynb)
*	[A collection of notebooks about neural networks](https://mybinder.org/v2/gh/Calysto/conx/master?filepath=binder%2Findex.ipynb)
*	[Example of interactive code snippets in a normal webpage](https://spacy.io/usage/linguistic-features#pos-tagging)
