# Useful reading

This is a living document collecting useful reading on the several aspects of reproducible research and writing a book. These resources can either be used as a source for writing the book or further reading to point to. References highlighted with ! are not open access and the full text will be shared within the team through other means.

## Accessibility
GOV.UK (2018). Making your service accessible: an introduction. https://www.gov.uk/service-manual/helping-people-to-use-your-service/making-your-service-accessible-an-introduction.

## Open Access

## Data Sharing

## Reproducibility crisis

### General/overview studies

Baker, M. (2016). 1,500 scientists lift the lid on reproducibility. Nature, 533(7604), 452–454. https://doi.org/10.1038/533452a - with the data available as Penny, D. (2016). Nature Reproducibility survey [Data set]. Figshare. https://doi.org/10.6084/m9.figshare.3394951.v1

Gall T, Ioannidis JPA, Maniadis Z (2017) The credibility crisis in research: Can economics tools help? PLoS Biol 15(4): e2001846. https://doi.org/10.1371/journal.pbio.2001846

Ioannidis, J. P. A. (2005). Why Most Published Research Findings Are False. PLoS Medicine, 2(8), e124. https://doi.org/10.1371/journal.pmed.0020124

### Computational/digital issues

Business/Management:
Bergh, D. D., Sharp, B. M., Aguinis, H., & Li, M. (2017). Is there a credibility crisis in strategic management research? Evidence on the reproducibility of study findings. Strategic Organization, 15(3), 423–436. https://doi.org/10.1177/1476127017701076

Psychology:
Open Science Collaboration (2015). Estimating the reproducibility of psychological science. Science, 349(6251), aac4716-aac4716. https://doi.org/10.1126/science.aac4716

### Non-computational/analog reproducibility
 
Biosciences:
Baker, M. (2015). Reproducibility crisis: Blame it on the antibodies. Nature, 521(7552), 274–276. https://doi.org/10.1038/521274a 

## Reproducible workflows
Lawrence, N. D. (2017). Data readiness levels. arXiv preprint arXiv:1705.02245. https://arxiv.org/abs/1705.02245

## Sharing of code

## Digital Preservation of data and code

## Licensing

Stodden, V. (2009). Enabling reproducible research: Open licensing for scientific innovation. Available at https://web.stanford.edu/~vcs/papers/ERROLSI03092009.pdf

Wilkinson, J. M., Flaherty, B., Hearne, S., Lynch, H., Lamond, H., Dewson, N., … Amos, H. (2016). Ownership And Licensing Of Research Data (Version 1.0). Zenodo. https://doi.org/10.5281/zenodo.1167976

Bernholdt, D. E. (2017). An Introduction to Software Licensing. Figshare. https://doi.org/10.6084/m9.figshare.4696285.v1


## Tools

## Existing guidelines
Center for Open Science. Transparency and Openness Promotion (TOP) Guidelines. https://cos.io/our-services/top-guidelines/

Broman et al. (2017). Recommendations to Funding Agencies for Supporting Reproducible Research. American Statistical Association. https://www.amstat.org/asa/files/pdfs/POL-ReproducibleResearchRecommendations.pdf

Society for Neuroscience. (2015). Practices for Scientific Rigor: A Resource for Discussion, Training, and Practice. https://www.sfn.org/sitecore/content/Home/SfN/News-and-Calendar/Neuroscience-Quarterly/Spring-2015/~/link.aspx?_id=9CC809B230444457A239368876C4A558&_z=z

Federation of American Societies for Experimental Biology (2016). Enhancing Research Reproducibility: Recommendations from the Federation of American Societies for Experimental Biology. https://www.faseb.org/Portals/2/PDFs/opa/2016/FASEB_Enhancing%20Research%20Reproducibility.pdf

Not that relevant but for completeness (also quite nice to see an example of a long version and a checklist):

ARRIVE guidelines: https://www.nc3rs.org.uk/arrive-guidelines

CONSORT guidelines: http://www.consort-statement.org/
