# UKRI Cloud Workshop

* Website: https://cloud.ac.uk
* Application form: https://docs.google.com/forms/d/1QG9xDIDlbfrAPZu_gZ5miucbBfZuHFGzgnP5ezC0v3w/viewform?edit_requested=true
* Location: The Francis Crick Institute, London, UK
* Date: 12 February 2019

### Authors 

* [Sarah Gibson](https://www.turing.ac.uk/people/researchers/sarah-gibson) ([*The Alan Turing Institute*](https://www.turing.ac.uk)) on behalf of **The Turing Way Collaboration**

### Abstract

We aim to support the scientific method across all fields of research using cloud computing platforms to provide reproducible, reliable and reusable analyses.
We plan to achieve this through capturing computing environments without need for installation, facilitating access to advanced computing resources and providing a "safe haven" for private repositories.

[Binder](http://conference.scipy.org/proceedings/scipy2018/pdfs/project_jupyter.pdf)[1]/[BinderHub](https://binderhub.readthedocs.io/en/latest/index.html) is a cloud platform that captures the computing environment of a GitHub repository within a Docker image.
It then provides an interactive browser from which code can be run in the environment under which it was developed without placing installation responsibilities on the user. BinderHubs can be built anywhere in the world and hosted in minimal installation time.
Building a locally hosted BinderHub is advantageous as it would facilitate the use of private repositories and make available a greater variety of computing resources - facilities which are not currently available on the public Binder service.

By harnessing the power of cloud computing and building a BinderHub with expanded capabilities, scientific analyses can become more accessible and transparent to the wider community.
We can improve reproducibility by making it easy to showcase and re-run analyses, improve reliability by making it easy to review analyses and catch bugs early in the development process without installation, and improve the reusability of the code by capturing the computing environment.

[1] Project Jupyter, Bussonnier, M., Forde, J., Freeman, J., Granger, B., Head, T., … Willing, C. (2018). Binder 2.0 - Reproducible, interactive, sharable environments for science at scale. In Proceedings of the 17th Python in Science Conference. SciPy. https://doi.org/10.25080/majora-4af1f417-011

### Submission Info

This was submitted as a Demonstration under the "Cloud Hosting for Virtual Research Environments" category.
