# Code of Conduct

We value the participation of every member of our community and want to ensure an that every contributor has an enjoyable and fulfilling experience.
Accordingly, everyone who participates in the Turing Way project is expected to show respect and courtesy to other community members at all times.

Kirstie Whitaker, as PI of this project, and all project members, are dedicated to a ***harassment-free experience for everyone***, regardless of gender, gender identity and expression, sexual orientation, disability, physical appearance, body size, race, age or religion. **We do not tolerate harassment by and/or of members of our community in any form**.

We are particularly motivated to support new and/or anxious collaborators, people who are looking to learn and develop their skills, and anyone who has experienced discrimination in the past.

To make clear what is expected, we ask all members of the community to conform to the following Code of Conduct.

* [1 Introduction](#1-introduction)
* [2 Code of Conduct](#2-code-of-conduct)
  * [2.1 Expected Behaviour](21-expected-behaviours)
  * [2.2 Unacceptable Behaviour](#22-unacceptable-behaviour)
  * [2.3 Consequences of Unacceptable Behaviour](#23-consequences-of-unacceptable-behaviour)
  * [2.4 Feedback](#24-feedback)
* [3 Incident Reporting Guidelines](#3-incident-reporting-guidelines)
  * [3.1 Contact points](#31-contact-points)
  * [3.2 Alternate contact points](#32-alternate-contact-points)
  * [3.3 What to do if someone is in physical danger](#33-what-to-do-if-someone-is-in-physical-danger)
  * [3.4 Code of Conduct Enforcement](#34-code-of-conduct-enforcement)
* [4 Enforcement Manual](#4-enforcement-manual)
  * [4.1 The Code of Conduct Committee](#41-the-code-of-conduct-committee)
  * [4.2 Urgent Situations: Acting Unilaterally](#42-urgent-situations-acting-unilaterally)
  * [4.3 Less-Urgent Situations](#43-less-urgent-situations)
  * [4.4 Resolutions](#44-resolutions)
  * [4.5 Conflicts of Interest](#45-conflicts-of-interest)
* [5 Acknowledgements](#5-acknowledgements)

## 1 Introduction

The Turing Way is a community-oriented and -led project.
We value the involvement of everyone in the community.
We are committed to creating a friendly and respectful place for learning, teaching and contributing.
All participants in our in-person events and online communications are expected to show respect and courtesy to others at all times.

To make clear what is expected, everyone participating in activities associated with the Turing Way project is required to conform to this Code of Conduct.
This Code of Conduct applies to all spaces managed by the Turing Way project including, but not limited to, in-person focus groups and workshops, and communications online via GitHub.

The lead investigator of the Turing Way - Dr Kirstie Whitaker - is responsible for enforcing the Code of Conduct.
She can be contacted by emailing [kwhitaker@turing.ac.uk](mailto:kwhitaker@turing.ac.uk).
You may contact [Anna Krystalli](mailto:a.krystalli@sheffield.ac.uk) or [Ben Murton](mailto:bmurton@turing.ac.uk) if you would prefer not to contact Dr Whitaker.

Reports may be reviewed by other members of the core development team, unless there is a conflict of interest, and will be kept confidential.

## 2 Code of Conduct

The Turing Way team are dedicated to providing a welcoming and supportive environment for all people, regardless of background or identity.
As such, we do not tolerate behaviour that is disrespectful to our community members or that excludes, intimidates, or causes discomfort to others.
We do not tolerate discrimination or harassment based on characteristics that include, but are not limited to: gender identity and expression, sexual orientation, disability, physical appearance, body size, citizenship, nationality, ethnic or social origin, pregnancy, familial status, veteran status, genetic information, religion or belief (or lack thereof), membership of a national minority, property, age, education, socio-economic status, technical choices, and experience level.

Everyone who participates in the Turing Way project activities is required to conform to this Code of Conduct.
This Code of Conduct applies to all spaces managed by the Turing Way project including, but not limited to, in person focus groups and workshops, and communications online via GitHub.
By participating, contributors indicate their acceptance of the procedures by which the Turing Way project core development team resolves any Code of Conduct incidents, which may include storage and processing of their personal information.

### 2.1 Expected Behaviour

We are confident that our community members will together build a supportive and collaborative atmosphere at our events and during online communications.
The following bullet points set out explicitly what we hope you will consider to be appropriate community guidelines:

* **Be respectful of different viewpoints and experiences**. Do not engage in homophobic, racist, transphobic, ageist, ableist, sexist, or otherwise exclusionary behaviour.
* **Use welcoming and inclusive language**. Exclusionary comments or jokes, threats or violent language are not acceptable. Do not address others in an angry, intimidating, or demeaning manner. Be considerate of the ways the words you choose may impact others. Be patient and respectful of the fact that English is a second (or third or fourth!) language for some participants.
* **Do not harass people**. Harassment includes unwanted physical contact, sexual attention, or repeated social contact. Know that consent is explicit, conscious and continuous—not implied. If you are unsure whether your behaviour towards another person is welcome, ask them. If someone tells you to stop, do so.
* **Respect the privacy and safety of others**. Do not take photographs of others without their permission. Do not share other participant’s personal experiences without their express permission. Note that posting (or threatening to post) personally identifying information of others without their consent ("doxing") is a form of harassment.
* **Be considerate of others’ participation**. Everyone should have an opportunity to be heard. In update sessions, please keep comments succinct so as to allow maximum engagement by all participants. Do not interrupt others on the basis of disagreement; hold such comments until they have finished speaking.
* **Don’t be a bystander**. If you see something inappropriate happening, speak up. If you don't feel comfortable intervening but feel someone should, please feel free to ask a member of the Code of Conduct response team for support.
* As an overriding general rule, please **be intentional in your actions and humble in your mistakes**.

All interactions should be professional regardless of platform: either online or in-person.
See [this explanation of the four social rules](https://www.recurse.com/manual#sub-sec-social-rules) - no feigning surprise, no well-actually's, no back-seat driving, no subtle -isms - for further recommendations for inclusive behaviours.

### 2.2 Unacceptable Behaviour

Examples of unacceptable behaviour by Turing Way community members at any project event or platform include:

* written or verbal comments which have the effect of excluding people on the basis of membership of any specific group
* causing someone to fear for their safety, such as through stalking, following, or intimidation
* violent threats or language directed against another person
* the display of sexual or violent images
* unwelcome sexual attention
* nonconsensual or unwelcome physical contact
* sustained disruption of talks, events or communications
* insults or put downs
* sexist, racist, homophobic, transphobic, ableist, or exclusionary jokes
* excessive swearing
* incitement to violence, suicide, or self-harm
* continuing to initiate interaction (including photography or recording) with someone after being asked to stop
* publication of private communication without consent

### 2.3 Consequences of Unacceptable Behaviour

Participants who are asked to stop any inappropriate behaviour are expected to comply immediately.
This applies to all Turing Way community events and platforms, either online or in-person.
If a participant engages in behaviour that violates this Code of Conduct, any member of the core development team may warn the offender, ask them to leave the event or platform (without refund), or impose any other appropriate sanctions (see the [enforcement manual](#enforcement-manual) for details).

### 2.4 Feedback

This Code of Conduct is not intended as a static set of rules by which everyone must abide.
Rather, you are invited to make suggestions for updates or clarifications by contacting Dr Kirstie Whitaker at [kwhitaker@turing.ac.uk](mailto:kwhitaker@turing.ac.uk) or by making a pull request to this document on GitHub.

## 3 Incident Reporting Guidelines

### 3.1 Contact points

If you feel able to, please contact Kirstie Whitaker by email at [kwhitaker@turing.ac.uk](mailto:kwhitaker@turing.ac.uk).

### 3.2 Alternate contact points

If you do not feel comfortable contacting Kirstie Whitaker, please report an incident to Anna Krystalli by email at [a.krystalli@sheffield.ac.uk](mailto:a.krystalli@sheffield.ac.uk).

Alternatively, if you would like to contact someone outside of the core development team, please contact Ben Murton by email at [bmurton@turing.ac.uk](mailto:bmurton@turing.ac.uk).

### 3.3 What to do if someone is in physical danger

If you believe someone is in physical danger, please contact the appropriate emergency responders.

### 3.4 Code of Conduct Enforcement

A detailed enforcement policy is available in the Enforcement Manual below.

## 4 Enforcement Manual

This is the enforcement manual followed by the Turing Way project research team.
It's used when we respond to an issue to make sure we're consistent and fair.
Enforcement of the Code of Conduct should be respectful and not include any harassing behaviours.

### 4.1 The Code of Conduct Committee

The Code of Conduct committee is:

* Kirstie Whitaker: kwhitaker@turing.ac.uk
* Anna Krystalli: a.krystalli@sheffield.ac.uk
* Ben Murton: bmurton@turing.ac.uk

As the community grows, we will seek to build a larger committee including members outside of the core development team.

### 4.2 Urgent Situations: Acting Unilaterally

If the incident involves physical danger, or involves a threat to anyone's safety (e.g. threats of violence), any member of the community may -- and should -- act unilaterally to protect the safety of any community member.
This can include contacting law enforcement (or other local personnel) and speaking on behalf of the Turing Way team.

If the act is ongoing, any community member may act immediately, before reaching consensus, to diffuse the situation.
In ongoing situations, any member may at their discretion employ any of the tools available in this enforcement manual, including bans and blocks online, or removal from a physical space.

In situations where an individual community member acts unilaterally, they must inform Kirstie Whitaker as soon as possible, and report their actions for review within 24 hours.

### 4.3 Less-Urgent Situations

Upon receiving a report of an incident, the CoC committee will review the incident and determine, to the best of her ability:

- whether this is an ongoing situation
- whether there is a threat to anyone's physical safety
- what happened
- whether this event constitutes a Code of Conduct violation
- who, if anyone, was the bad actor

This information will be collected either in person or in writing.
The CoC committee will provide a written summary of the information surrounding the incident.
All participants will be anonymised in the summary report, referred to as "Community Member 1", "Community Member 2", or "Research Team Member 1".
The "de-anonymising key" will be kept in a separate file and only accessed to link repeated reports against the same person over time.

The CoC committee will aim to have a resolution agreed upon within one week.
In the event that a resolution can't be determined in that time, a member of the CoC committee will respond to the reporter(s) with an update and projected timeline for resolution.

### 4.4 Resolutions

The CoC committee will seek to agree on a resolution by consensus of all members investigating the report in question.
If the committee cannot reach consensus and deadlocks for over a week, Dr Whitaker, as lead investigator of the Turing Way project, will break the tie.
If Dr Whitaker is unable to take part in the discussion due to a conflict of interest, Dr Ben Murton, as an external member of the CoC committee, will make the decision.

Possible responses may include:

* A mediated conversation or agreement between the impacted community members.
* A request for a verbal or written apology, public or private, from a community member.
* A public announcement clarifying community responsibilities under the Code of Conduct.
* Nothing, if the issue reported is not a violation or outside of the scope of this Code of Conduct.
* A private in-person conversation between a member of the research team and the individual(s) involved.
  In this case, the person who has the conversation will provide a written summary for record keeping.
* A private written reprimand from a member of the research team to the individual(s) involved.
  In this case, the research team member will deliver that reprimand to the individual(s) over email, cc'ing Kirstie Whitaker for record keeping.
* A public announcement of an incident, ideally in the same venue that the violation occurred (i.e. on the listserv for a listserv violation; GitHub for a GitHub violation, etc.).
  The committee may choose to publish this message elsewhere for posterity.
* An imposed "time out" from online spaces.
  Kirstie Whitaker will communicate this "time out" to the individual(s) involved.
* A permanent or temporary ban from some or all Turing Way project spaces (GitHub, in-person events etc).
  The research team will maintain records of all such bans so that they may be reviewed in the future, extended to a Code of Conduct safety team as it is built, or otherwise maintained.
  If a member of the community is removed from an event they will not be reimbursed for any part of the event that they miss.

Once a resolution is agreed upon, but before it is enacted, a member of the CoC committee will contact the original reporter and any other affected parties and explain the proposed resolution.
The CoC committee member will ask if this resolution is acceptable, and must note feedback for the record.
However, the CoC committee is not required to act on this feedback.

### 4.5 Conflicts of Interest

In the event of any conflict of interest such that Dr Whitaker is not able to evaluate or enforce the reported violation, Ben Murton will take Kirstie's place.

## 5. Acknowledgements

This code is adapted from the [Carpentries Code of Conduct](https://docs.carpentries.org/topic_folders/policies/code-of-conduct.html)  with sections from the [Alan Turing Institute Data Study Group Code of Conduct](https://docs.google.com/document/d/1iv2cizNPUwtEhHqaezAzjIoKkaIX02f7XbYmFMXDTGY/edit).
Both are used under the creative commons attribution license.

The Carpentries Code of Conduct was adapted from guidelines written by the [Django Project](https://www.djangoproject.com/conduct/enforcement-manual/), which was itself based on the [Ada Initiative template](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Responding_to_reports) and the [PyCon 2013 Procedure for Handling Harassment Incidents](https://us.pycon.org/2013/about/code-of-conduct/harassment-incidents/).
Contributors to the Carpentries Code of Conduct were: Adam Obeng, Aleksandra Pawlik, Bill Mills, Carol Willing, Erin Becker, Hilmar Lapp, Kara Woo, Karin Lagesen, Pauline Barmby, Sheila Miguez, Simon Waldman, Tracy Teal.

The Turing Institute Data Study Group Code of Conduct was heavily adapted from the [Citizen Lab Summer Institute 2017 Code of Conduct](https://citizenlab.ca/summerinstitute/codeofconduct.html) and used under a CC BY 2.5 CA license.
Citizen Lab based their Code of Conduct on the [xvzf Code of Conduct](http://xvzf.io/), the [Contributor Covenant](http://contributor-covenant.org/), the [Django Code of Conduct and Reporting Guide](https://www.djangoproject.com/conduct/) and we are also grateful for [this guidance from Ada Initiative](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Responding_to_reports).

We really appreciate the work that all of the communities linked above have put into creating such a well considered process.

This Code of Conduct is licensed under a [Creative Commons Attribution 4.0 International](https://creativecommons.org/licenses/by/4.0/) (CC BY 4.0 CA) license which means you are free to share and adapt the work so long as the attribution to Kirstie Whitaker and the Turing Way community is retained, along with the attribution to the Carpentries, the Alan Turing Institute Data Study Group organising team, Citizen Lab and the other resources.