%% analysis_Exp02_RB2.m
%% Analyze data from Exp02_RB1 (rating task 1(glass) - 5(mirror))
%% by Hideki Tamura
%% Last update:20190206
clear;
close all;
inDirImg = './images_setExp02_RB2/';

PV = getPlotVariables();
copyflag = 0;

% 5110 -> 0-1
% 1051 -> 1-5
maxScaleTmp = 5; % 5
minScaleTmp = 1; % 1
maxScaleShow = 1; % 1
minScaleShow = 0; % 0

inDir = './result/';
subjectNum = 10;
subData = cell(subjectNum,1); % Subjects all data
subNames = cell(subjectNum,1); % Subjects name
subAges = zeros(subjectNum,1); % Subject age
trialNum = 1680;
stimList = reshape(1:(trialNum*subjectNum),trialNum,subjectNum);
results = zeros(trialNum,7,subjectNum);

count = 1;
dirInfo = dir(inDir);
dirInfo(ismember({dirInfo.name}, {'.', '..', '.DS_Store'})) = [];
for i = 1:subjectNum
    tmp = dirInfo(i,1);
    tmp2 = dir([tmp.folder '/' tmp.name '/*.mat']);
    subData{count,1} = load([tmp2.folder '/' tmp2.name]);
    subNames{count,1} = subData{count,1}.subjectname;
    subAges(count,1) = str2double(subData{count,1}.subjectage);
    results(:,:,count) = subData{count,1}.result; 
    count = count + 1;
end
subAges_ave = mean(subAges);
subAges_std = std(subAges,0,1);
subAges_se = subAges_std ./ sqrt(length(subAges));
% 25.1 +- 3.8 ages (N=10)

%% Collect data
raw = results(:,[2 6],:); % cnd(1-560), answer rating
raw(:,2,:) = (raw(:,2,:) - minScaleTmp) / (maxScaleTmp - minScaleTmp); % Scaling
edges = linspace(minScaleShow,maxScaleShow,5+1);
xMargin = (edges(2) - edges(1)) / 2;

rawAll = zeros(560,subjectNum); % imgNum, subjectNum
for s = 1:subjectNum
    for i = 1:trialNum
        imgID = raw(i,1,s);
        rating = raw(i,2,s);
        rawAll(imgID,s) = rawAll(imgID,s) + rating;
    end
end
rawAll = rawAll ./ 3; % 3 repeating

rawAll_gans = rawAll(1:500,:);
rawAll_rend = rawAll(501:560,:);
clear rawAll;

rawAve_gans = mean(rawAll_gans,2);
rawStd_gans = std(rawAll_gans,0,2);
rawSe_gans = rawStd_gans ./ sqrt(subjectNum);

binMax = 180;
%% Show histograms (GANs) both
[M,~] = histcounts(rawAve_gans,edges);
figure; hold on;
h = histogram(rawAve_gans, edges);
h.FaceColor = PV.ColsL(3,:);
text(edges(1:end-1)+xMargin,h.BinCounts+binMax/40,string(h.BinCounts),'HorizontalAlignment','center',...
    'FontName','Helvetica','FontSize',16);
xlim([minScaleShow maxScaleShow]);
ylim([0 binMax]);
% ylim([0 350]);
xlabel('Score');
ylabel('Frequency');
set(gca,'FontSize',20);
