%% analysis_Exp02_RB1.m
%% Analyze data from Exp02_RB1 (Yes/No task for pre-screening)
%% by Hideki Tamura
%% Last update:20190206
clear;
close all;

PV = getPlotVariables();

% Load data
inDir = './result/';
dirInfo = dir(inDir);
subjectNum = length(dirInfo) - 3;
subData = cell(subjectNum,1); % Subjects all data
subNames = cell(subjectNum,1); % Subjects name
subAges = zeros(subjectNum,1); % Subject age
results = zeros(1400,8,subjectNum);
for i = 1:subjectNum
    tmp = dirInfo(i+3,1);
    tmp2 = dir([tmp.folder '/' tmp.name '/*.mat']);
    subData{i,1} = load([tmp2.folder '/' tmp2.name]);
    subNames{i,1} = subData{i,1}.subjectname;
    subAges(i,1) = str2double(subData{i,1}.subjectage);
    results(:,:,i) = subData{i,1}.result; 
end

subAges_ave = mean(subAges);
subAges_std = std(subAges,0,1);
subAges_se = subAges_std ./ sqrt(length(subAges));
% 24.8 +- 4.1 ages

%% Collect data
raw = zeros(1400,7);
for s = 1:subjectNum
    for i = 1:1400
        x = results(i,:,s);
        ind = x(2);
        raw(ind,1:5) = x(2:6); % index
        if x(7) == 1 % accepted
            raw(ind,6) = raw(ind,6) + x(7);
        end
        raw(ind,7) = raw(ind,7) + x(8); % RT
    end
end
res_ave = raw(:,6) ./ subjectNum; % Mean response
rt_ave = raw(:,7) ./ subjectNum; % Mean RT (This should be remove outliers)

% For histogram
res_ave_hist = zeros(11,1);
for i = 1:length(res_ave)
    res_ave_hist(res_ave(i,1).*10+1,1) = res_ave_hist(res_ave(i,1).*10+1,1) + 1;
end

%% Result of raw data count
th = 6; % 60% observers answered yes
numCandidate = sum(res_ave_hist(th+1:end,1));
figure; hold on;
h = bar([res_ave_hist(1:th,1); nan(4,1)],'hist','FaceColor',[0.5 0.5 0.5]);
h.FaceColor = [0.8 0.8 0.8];
h = bar([nan(th, 1); res_ave_hist(th+1:11,1)],'hist','FaceColor',[0.5 0.5 0.5]);
h.FaceColor = PV.ColsM(3,:);
xticks(0:11);
xticklabels({'','0','1','2','3','4','5','6','7','8','9','10'});
xlim([0.5 11.5]);
ylim([0 400]);
xlabel('Count of yes answers');
ylabel('Frequency');
set(gca, 'FontSize', PV.FontSize);

