%% analysis_Exp02_RA3.m
%% Analyze data from Exp02_RA3 (rating task 1(glass) - 5(mirror))
%% by Hideki Tamura
%% Last update:20190206
clear;
close all;

inDirImg = './images_setExp02_RA3/';
% Output
% outDirImg = ''; % Specify

PV = getPlotVariables();
FUD = getFlatUD(0);
copyflag = 0;

% 5110 -> 0-1
% 1051 -> 1-5
maxScaleTmp = 5; % 5
minScaleTmp = 1; % 1
maxScaleShow = 1; % 1
minScaleShow = 0; % 0

inDir = './result/';
subjectNum = 10;
subData = cell(subjectNum,1); % Subjects all data
subNames = cell(subjectNum,1); % Subjects name
subAges = zeros(subjectNum,1); % Subject age
trialNum = 1566;
stimList = reshape(1:(trialNum*subjectNum),trialNum,subjectNum);
results = zeros(trialNum,7,subjectNum);

count = 1;
dirInfo = dir(inDir);
dirInfo(ismember({dirInfo.name}, {'.', '..', '.DS_Store'})) = [];
for i = 1:subjectNum
    tmp = dirInfo(i,1);
    tmp2 = dir([tmp.folder '/' tmp.name '/*.mat']);
    subData{count,1} = load([tmp2.folder '/' tmp2.name]);
    subNames{count,1} = subData{count,1}.subjectname;
    subAges(count,1) = str2double(subData{count,1}.subjectage);
    results(:,:,count) = subData{count,1}.result; 
    count = count + 1;
end
subAges_ave = mean(subAges);
subAges_std = std(subAges,0,1);
subAges_se = subAges_std ./ sqrt(length(subAges));
% 24.8 +- 2.8 ages (N=10)

%% Collect data
%% count 1,2,0
%% trial, cnd(1-522), cnd(1-30000), Ground truth, index, answer rating, time
raw = results(:,[2 6],:); % cnd(1-522), answer rating
raw(:,2,:) = (raw(:,2,:) - minScaleTmp) / (maxScaleTmp - minScaleTmp); % Scaling
edges = linspace(minScaleShow,maxScaleShow,5+1);
xMargin = (edges(2) - edges(1)) / 2;

rawAll = zeros(522,subjectNum); % imgNum, subjectNum
for s = 1:subjectNum
    for i = 1:trialNum
        imgID = raw(i,1,s);
        rating = raw(i,2,s);
        rawAll(imgID,s) = rawAll(imgID,s) + rating;
    end
end
rawAll = rawAll ./ 3; % 3 repeating

rawAve = mean(rawAll,2);
rawStd = std(rawAll,0,2);
rawSe = rawStd ./ sqrt(subjectNum);
indMaterial = zeros(522,1);
indMaterial(1:522/2,1) = 1;
indMaterial(522/2+1:end,1) = 2;

%% Show histograms
for i = 1:2
    [N(i,:),~] = histcounts(rawAve(indMaterial==i,1),edges);
end
binMax = 140;
for i = 1:2
    figure; hold on;
    h = histogram(rawAve(indMaterial==i,1), edges);
    h.FaceColor = PV.ColsP(i,:);
    text(edges(1:end-1)+xMargin,h.BinCounts+binMax/40,string(h.BinCounts),'HorizontalAlignment','center',...
        'FontName','Helvetica','FontSize',16);
    xlim([minScaleShow maxScaleShow]);
    ylim([0 binMax]);
    xlabel('Score');
    ylabel('Frequency');
    set(gca,'FontSize',20);
end