%% analysis_Exp02_RA2.m
%% Analyze results of crowdsourcing experiment
%% by Hideki Tamura
%% Last update:20190206
clear;
close all;

PV = getPlotVariables();
copyflag = 0;

load('summarized_results.mat');

ind = allnumresults >= 3; % At least 3 observers judged
res = nanmean(allresponses(ind,:),2);
rawAll = res;
resAll = nanmean(allresponses,2); % All

% 5110 -> 0-1
% 1051 -> 1-5
maxScaleTmp = 5; % 5
minScaleTmp = 1; % 1
maxScaleShow = 1; % 1
minScaleShow = 0; % 0
res = (res - minScaleTmp) / (maxScaleTmp - minScaleTmp);
resAll = (resAll - minScaleTmp) / (maxScaleTmp - minScaleTmp);
edges = linspace(minScaleShow,maxScaleShow,5+1);
xMargin = (edges(2) - edges(1)) / 2;

indMaterial = zeros(length(res),1);
indMaterial(string(allgroundtruths(ind)) == 'Mirror') = 1;
indMaterial(string(allgroundtruths(ind)) == 'Glass') = 2;
indMaterialAll = zeros(length(resAll),1);
indMaterialAll(string(allgroundtruths) == 'Mirror') = 1;
indMaterialAll(string(allgroundtruths) == 'Glass') = 2;

%% Figure
for i = 1:2
    [N(i,:),~] = histcounts(res(indMaterial==i,1),edges);
end
binMax = ceil(max(N(:))/100)*100;
for i = 1:2
    figure; hold on;
    h = histogram(res(indMaterial==i,1), edges);
    h.FaceColor = PV.ColsP(i,:);
    text(edges(1:end-1)+xMargin,h.BinCounts+binMax/40,string(h.BinCounts),'HorizontalAlignment','center',...
        'FontSize',16,'FontName','Helvetica');
    xlim([minScaleShow maxScaleShow]);
    ylim([0 binMax]);
    xlabel('Score');
    ylabel('Frequency');
    set(gca,'FontSize',20);
end
