%% analysis_Exp02_RA1.m
%% Analyze data from Exp02_RA1 (Mirror/Glass task, or neither)
%% by Hideki Tamura
%% Last update:20190206
clear;
close all;

PV = getPlotVariables();

copyfroms = {'./images_setR1A_64/','./images_setR1B_64/'};
cfSublist1 = [ones(10,1); ones(10,1).*2];
cfSublist2 = [(1:10)'; (1:10)'];
% copyto = ''; % Specify

%% Load data
inDirs = {'./result_R1A','./result_R1B'};
subjectNum = 20;
subData = cell(subjectNum,1); % Subjects all data
subNames = cell(subjectNum,1); % Subjects name
subAges = zeros(subjectNum,1); % Subject age
trialNum = 1500;
stimList = reshape(1:(trialNum*subjectNum),trialNum,subjectNum);
results = zeros(trialNum,7,subjectNum);

count = 1;
for j = 1:2
    dirInfo = dir(inDirs{1,j});
    dirInfo(ismember({dirInfo.name}, {'.', '..', '.DS_Store'})) = [];
    for i = 1:10
        tmp = dirInfo(i,1);
        tmp2 = dir([tmp.folder '/' tmp.name '/*.mat']);
        subData{count,1} = load([tmp2.folder '/' tmp2.name]);
        subNames{count,1} = subData{count,1}.subjectname;
        subAges(count,1) = str2double(subData{count,1}.subjectage);
        if j == 1
            results(:,:,count) = subData{count,1}.result; 
        elseif j ==2
            addmat = zeros(1500,7);
            addmat(:,3) = 15000;
            results(:,:,count) = subData{count,1}.result + addmat;
        end
        count = count + 1;
    end
end
subAges_ave = mean(subAges);
subAges_std = std(subAges,0,1);
subAges_se = subAges_std ./ sqrt(length(subAges));
% 23.1 +- 1.4 ages (N=20)

%% Collect data
%% count 1,2,0
%% trial, cnd(1-1500), cnd(1-15000), Ground truth, index, ans, time
raw = results(:,[3 4 6],:);
for s = 1:subjectNum
    raw1d((s-1)*1500+1:s*1500,:) = raw(:,:,s);
end
raw1d_sort = sortrows(raw1d);
raw1d_sort1 = raw1d_sort(1:2:end-1,:); % Mirror
raw1d_sort2 = raw1d_sort(2:2:end,:); % Glass

%% 
% Ground truth: Mirror
figure; hold on;
set(gcf,'Position',[0 400 300 400]);
h1 = histogram(raw1d_sort1(:,3));
for i = 1:3
    text(i-1,h1.BinCounts(i)+300,num2str(h1.BinCounts(i)),...
        'HorizontalAlignment','center','FontSize',12,...
    'FontName','Helvetica');
end
xticks(0:2);
xticklabels({'Artifact','Mirror','Glass'});
title('Ground truth: Mirror');
ylim([0 12500]);
ylabel('Frequency');
set(gca,'FontSize',16);
h1.FaceColor = PV.ColsP(1,:);

% Ground truth: Glass
figure; hold on;
set(gcf,'Position',[400 400 300 400]);
h2 = histogram(raw1d_sort2(:,3));
for i = 1:3
    text(i-1,h2.BinCounts(i)+300,num2str(h2.BinCounts(i)),...
        'HorizontalAlignment','center','FontSize',12,...
        'FontName','Helvetica');
end
xticks(0:2);
xticklabels({'Artifact','Mirror','Glass'});
title('Ground truth: Glass');
ylim([0 12500]);
ylabel('Frequency');
set(gca,'FontSize',16);
h2.FaceColor = PV.ColsP(2,:);

h1.BinCounts
h2.BinCounts





