%% analysis_Exp01.m
%% Analyze data from Exp01 (rating task 1(glass) - 5(mirror))
%% by Hideki Tamura
%% Last update:20190206
clear;
close all;

inDirImg = './images_setExp01/';
% outDirImg = ''; % Specify

PV = getPlotVariables();
FUD = getFlatUD(0);
copyflag = 0;

% 5110 -> 0-1
% 1051 -> 1-5
maxScaleTmp = 5; % 5
minScaleTmp = 1; % 1
maxScaleShow = 1; % 1
minScaleShow = 0; % 0

inDir = './result/';
subjectNum = 10;
subData = cell(subjectNum,1); % Subjects all data
subNames = cell(subjectNum,1); % Subjects name
subAges = zeros(subjectNum,1); % Subject age
trialNum = 1000;
stimList = reshape(1:(trialNum*subjectNum),trialNum,subjectNum);
results = zeros(trialNum,7,subjectNum);

count = 1;
dirInfo = dir(inDir);
dirInfo(ismember({dirInfo.name}, {'.', '..', '.DS_Store'})) = [];
for i = 1:subjectNum
    tmp = dirInfo(i,1);
    tmp2 = dir([tmp.folder '/' tmp.name '/*.mat']);
    subData{count,1} = load([tmp2.folder '/' tmp2.name]);
    subNames{count,1} = subData{count,1}.subjectname;
    subAges(count,1) = str2double(subData{count,1}.subjectage);
    results(:,:,count) = subData{count,1}.result; 
    count = count + 1;
end
subAges_ave = mean(subAges);
subAges_std = std(subAges,0,1);
subAges_se = subAges_std ./ sqrt(length(subAges));
% 25.1 +- 5.2 ages (N=10) Exp01


%% Collect data
%% count 1,2,0
%% trial, cnd(1-1000), cnd(1-30000), Ground truth, index, answer rating, time
raw = results(:,[2 6],:); % cnd(1-1000), answer rating
raw(:,2,:) = (raw(:,2,:) - minScaleTmp) / (maxScaleTmp - minScaleTmp); % Scaling
edges = linspace(minScaleShow,maxScaleShow,5+1);
xMargin = (edges(2) - edges(1)) / 2;

rawAll = zeros(1000,subjectNum); % imgNum, subjectNum
for s = 1:subjectNum
    for i = 1:trialNum
        imgID = raw(i,1,s); % 1-1000(odd:mirror, even:glass)
        rating = raw(i,2,s);
        rawAll(imgID,s) = rawAll(imgID,s) + rating;
    end
end
rawAll = rawAll ./ 1; % 3 repeating
rawAve = mean(rawAll,2);
rawStd = std(rawAll,0,2);
rawSe = rawStd ./ sqrt(subjectNum);

% % RSA(1st-RDM -> 2nd-RDM)
% indOrder = [1:2:trialNum-1 2:2:trialNum]; % Reorder using 'indOrder'
% for s = 1:10
%     Ds(s,:) = pdist(rawAll(indOrder,s),'euclidean');
% end
% 
% DAve = pdist(rawAve(indOrder,1),'euclidean');
% showRDM(squareform(DAve),'RDM1000'); % The 1st-stage RDM (Mean of 10 obs)
% 
% [rhoRDM, pvalRDM] = corr(Ds');
% qRDM = 1 - rhoRDM;
% showRDM(qRDM,[],[0 1]); % The 2nd-stage RDM
% 
% clear Y aveY;
% [Ycmd,e] = cmdscale(qRDM);
% a = e/max(abs(e));
% Y = Ycmd;
% 
% visualizeRDM(Y,10,1); % MDS
% 
% 
indMaterial = zeros(1000,1);
indMaterial(1:2:end-1,1) = 1;
indMaterial(2:2:end,1) = 2;
% 
% %% Accuracy
% for s = 1:subjectNum
%     accAlltmp(s,1) = mean(rawAll(indMaterial==1,s) >= 0.5);
%     accAlltmp(s,2) = mean(rawAll(indMaterial==2,s) < 0.5);
%     accAll(s,1) = mean(accAlltmp(s,:),2);
% end
% accAve = mean(accAll);
% accStd = std(accAll,0,1);
% accSe = accStd ./ sqrt(subjectNum);
% 
% accAve2tmp(1) = mean(rawAve(indMaterial==1,1) >= 0.5);
% accAve2tmp(2) = mean(rawAve(indMaterial==2,1) < 0.5);
% accAve2 = mean(accAve2tmp);
% 
% %% Accuracy of 10 obs
% figure; hold on;
% fill([0.5 1.5 1.5 0.5],[accAve-2*accStd accAve-2*accStd accAve+2*accStd accAve+2*accStd],[0.5 0.5 0.5],'FaceAlpha',0.3, 'EdgeColor','none');
% for s = 1:subjectNum
%     plot(1,accAll(s,1),'ok','MarkerSize',5); 
% end
% plot(1,accAve,'ok','MarkerSize',10);
% plot(1,accAve2,'sr','MarkerSize',10);
% ylim([0.5 1]);
% xlim([0.5 1.5]);
% xticklabels({''});
% ylabel('Accuracy');
% set(gca,'FontSize',PV.FontSize);
% 
% 
% %% Correlation between an observers and remaining observers
% for s = 1:subjectNum
%     indOthers = 1:subjectNum;
%     indOthers(s) = [];
%     target = rawAll(:,s);
%     others = rawAll(:,indOthers);
%     othersAve = mean(others,2);
%     [rs(s,1) ps(s,1)] = corr(target,othersAve);
% end
% rsAve = mean(rs);
% rsStd = std(rs,0,1);
% rsSe = rsStd ./ sqrt(subjectNum);
% 
% 
% %% Correlation between each observers
% [rho, pval] = corr(rawAll);
% rhonan = rho - diag(diag(rho));
% rhonan(rhonan==0) = nan;
% aveRho = nanmean(rhonan);
% 
% figure; hold on; axis square;
% imagesc(rho);
% count = 1;
% for i = 1:subjectNum
%     for j = 1:subjectNum
% %         if i == j
% %             text(i,j,num2str(rho(i,j),'%3.2f'),'Color','w','HorizontalAlignment','center');
% %         else
%             text(i,j,num2str(rho(i,j),'%3.2f'),'Color','k','HorizontalAlignment','center');
% %         end
%         count = count + 1;
%     end
% end
% colormap(gray);
% colorbar;
% xlim([0.5 subjectNum+.5]);
% ylim([0.5 subjectNum+.5]);
% set(gca,'ydir','rev');
% caxis([0 1]);
% 
% %% Vertical axis: correlation
% figure; hold on;
% fill([0.5 2.5 2.5 0.5],[rsAve-2*rsStd rsAve-2*rsStd rsAve+2*rsStd rsAve+2*rsStd],[0.5 0.5 0.5],'FaceAlpha',0.3, 'EdgeColor','none');
% for s = 1:subjectNum
%     plot(1,rs(s,1),'ok','MarkerSize',5); % Mean correlation between an observers and remaining observers
%     plot(2,aveRho(1,s),'ok','MarkerSize',5); % Mean orrelation between each observers
% end
% plot(1,rsAve,'ok','MarkerSize',10);
% plot(2,mean(aveRho),'ok','MarkerSize',10);
% ylim([0 1]);
% xlim([0.5 2.5]);
% % xticks(1);
% xticklabels({''});
% ylabel('Correlation coefficient to human');
% set(gca,'FontSize',PV.FontSize);
% 
% 
% binMax = 350;
% %% Show histograms in each material
% for i = 1:2
%     [N(i,:),~] = histcounts(rawAve(indMaterial==i,1),edges);
% end
% for i = 1:2
%     figure; hold on;
%     h = histogram(rawAve(indMaterial==i,1), edges);
%     h.FaceColor = PV.ColsP(i,:);
%     text(edges(1:end-1)+xMargin,h.BinCounts+binMax/40,string(h.BinCounts),'HorizontalAlignment','center');
%     xlim([minScaleShow maxScaleShow]);
%     ylim([0 binMax]);
%     xlabel('Score');
%     ylabel('Frequency');
% end
% 
% % Mean ratings 
% matAve(1,1) = mean(rawAve(indMaterial==1,1)); % mirror
% matAve(2,1) = mean(rawAve(indMaterial==2,1)); % glass
% matAve(:,2) = (matAve .* 4) + 1; % 1 ~ 5

%% Histogram (overlay)
figure; hold on;
h1 = histogram(rawAve(indMaterial==1,1)); % mirror
h1.BinWidth = 0.2;
h1.FaceColor = PV.ColsP(1,:);
h2 = histogram(rawAve(indMaterial==2,1)); % glass
h2.BinWidth = 0.2;
h2.FaceColor = PV.ColsP(2,:);
set(gca,'FontSize',PV.FontSize);
xlabel('Score','FontSize',20);
ylabel('Frequency','FontSize',20);
% legend('Mirror','Glass','location','northeast');
xlim([0 1]);
ylim([0 350]);
