% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/9_Functions_test_package_4Methods_random_XYsites.R
\name{refit.occ}
\alias{refit.occ}
\title{Refit occupancy raster layers function}
\usage{
refit.occ(occ.new, layers, time.fire, fire.freq, jj, dist.occ.time,
  dist.occ.freq, n.species)
}
\arguments{
\item{occ.new}{A raster stack of occupancy maps. Raster layers for fire sensitive species are updated depending on the simulated fire history at time jj}

\item{layers}{An array of covararite values at each site. These are used to update the occ.new raster stack}

\item{time.fire}{A vector specifying the time since fire at each site in year jj given the simulated fire history}

\item{fire.freq}{A vector specifying the number of fires at sites during a 15 year moving window}

\item{jj}{The year of the monitoring program}

\item{dist.occ.time}{An integer indentifying which layer in the covariate raster stack is the time since the last disturbance layer}

\item{dist.occ.freq}{An integer indentifying which layer in the covariate raster stack is the disturbance frequency layer}

\item{n.species}{Number of species included in power simulations}
}
\description{
This function is only called if stochastic disturbances are modelled at sites. It re-maps occupancy for disturbance-sensitive species given the simulated disturbance events and the relationship between distrubances and occupancy
It returns a new raster stack with the updated occupancy raster layers for each species
}
