% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/9_Functions_test_package_4Methods_random_XYsites.R
\name{refit.det}
\alias{refit.det}
\title{Refit detectability raster layers function}
\usage{
refit.det(det.method1.new, det.method2.new, det.method3.new, det.method4.new,
  layers, time.fire, fire.freq, jj, dist.occ.time, dist.occ.freq, n.species)
}
\arguments{
\item{det.method1.new}{An array of detectability estimates for each species at sites over time using method 1.}

\item{det.method2.new}{An array of detectability estimates for each species at sites over time using method 2.}

\item{det.method3.new}{An array of detectability estimates for each species at sites over time using method 3.}

\item{det.method4.new}{An array of detectability estimates for each species at sites over time using method 4.}

\item{layers}{An array of covararites at each site used to update the detectability arrays given the simulated disturbances}

\item{time.fire}{A vector specifying the time since a disturbance at each site in year jj given the simulated disturbances}

\item{fire.freq}{A vector specifying the number of disturbances at sites during a 15 year moving window}

\item{jj}{The year of the monitoring program}

\item{dist.occ.time}{An integer indentifying which layer in the covariate raster stack is the time since the last disturbance layer}

\item{dist.occ.freq}{An integer indentifying which layer in the covariate raster stack is the disturbance frequency layer}

\item{n.species}{Number of species included in power simulations}
}
\description{
This function is called only if a stochastic disturbance is modelled at sites. It re-fits the detectability raster layers for disturbance sensitive species given simulated disturbance events and the disturbance history
A new raster stack is returned for each detection method
}
