% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/9_Functions_test_package_4Methods_random_XYsites.R
\name{fit.occ.1method}
\alias{fit.occ.1method}
\title{Fit occupancy model with one detection method}
\usage{
fit.occ.1method(method, repeats, s.years, n.sites, xy.sites, park.ID,
  park.level, powcnt, fail, pow.park, fail.park, value, ss, two.tailed, n.park)
}
\arguments{
\item{method}{The detection method relevant to species ss}

\item{repeats}{The number of repeat visits for the specified detection method}

\item{s.years}{A vector specifying the years that monitoring occurs. Note, monitoring must be done in the final year (i.e. Tmax)}

\item{n.sites}{The number of sites in which to simulate monitoring}

\item{xy.sites}{The XY coordinates of monitored sites, plus the park site ID}

\item{park.ID}{A vector identifying which park each site is in}

\item{park.level}{Set to TRUE if power is estimated within park-level management unit, FALSE to estimate power only across the landscape}

\item{powcnt}{A vector that keeps track of how many times a significant trend in occupancy is detected across the landscape}

\item{fail}{A vector that keeps track of how many times the occupancy model could not be fitted to the simulated detection histories from all sites in the landscape}

\item{pow.park}{A vector that keeps track of how many times a significant trend in occupancy is detected within each park}

\item{fail.park}{A vector that keeps track of how many times the occupancy model could not be fitted to simulated detection histories generated from within each park}

\item{value}{The critical value used to calculate confidence intervals around the trend parameter, depending on the Type I error rate and a one-tailed or two-tailed test}

\item{ss}{An index to loop through each species}

\item{two.tailed}{Set to TRUE if conducting a two-tailed test, FALSE to conduct a one-tailed test}

\item{n.park}{The number of parks in which to estimate power}
}
\description{
This function fits an occupancy model to simulated detection histories using the package unmarked for species that are detected using only one detection method
A trend in occupancy is estimated from the simulated detection histories. Confidence intervals are calculated depending on the Type I error rate. A one-tailed or two-tailed significance test is then conducted on the trend parameter
A one-tailed test looks to see if the upper or lower confidence interval is greater than or less than zero. A two-tailed test assesses whether both the upper and lower confidence
intervals have the same sign (i.e. are both positive or negative). If park.power = TRUE, model fitting is repeated on sites from within each park-level management unit.
}
