# Generation of figures within  manuscript
################################################################################

######################Figure 2
Dlg4=read.csv("Dlg4.csv")
library(plyr)
countDataPoints<-function(dataset, depVariable){
	print(sum(is.finite(dataset[ , depVariable])))
}

Index = ddply(.data=Dlg4, .variables=c("Genotype", "Gender"), .fun=countDataPoints, depVariable="Lean.Mass")		

png("Dlg4_LM_Male.png")
scatterplot(data=Dlg4, Lean.Mass~Weight|Genotype, subset= Dlg4$Gender=="Male", grid=FALSE, legend.plot=FALSE, cex.axis=1.4, cex.lab=1.6, lwd=3, smooth=FALSE, xlab="Body weight (g)", ylab="Lean mass (g)")
legend(23,29, # places a legend at the appropriate place 
		c("Wildtype","Dlg4"), # puts text in the legend
		
		lty=c(1,1), # gives the legend appropriate symbols (lines)
		
		,col=c("black","red"),bty="n", lwd=3, cex=1.6)
dev.off()

png("Dlg4_LM_Female.png")
scatterplot(data=Dlg4, Lean.Mass~Weight|Genotype, subset= Dlg4$Gender=="Female", grid=FALSE, legend.plot=FALSE, cex.axis=1.4, cex.lab=1.6, lwd=3, smooth=FALSE, xlab="Body weight (g)", ylab="Lean mass (g)")
legend(15,24, # places a legend at the appropriate place 
		c("Wildtype","Dlg4"), # puts text in the legend
		
		lty=c(1,1), # gives the legend appropriate symbols (lines)
		
		,col=c("black","red"),bty="n", lwd=3, cex=1.6)

dev.off()


library(phenStat)
PhenObject=PhenList(Dlg4, testGenotype="Dlg4/Dlg4", dataset.colname.sex="Gender", dataset.clean=TRUE,dataset.colname.batch="Assay.Date", dataset.colname.genotype="Genotype", dataset.colname.weight="Weight", dataset.values.male="Male", 		dataset.values.female="Female") 
Modelfeatures=testDataset(PhenObject, depVariable="Lean.Mass", equation="withWeight", transformValues=FALSE)  
summaryOutput(Modelfeatures)
Modelfeatures=testDataset(PhenObject, depVariable="Lean.Mass", equation="withoutWeight", transformValues=FALSE)  
summaryOutput(Modelfeatures)


######################Figure 3

df1=read.csv("Akt2dataset.csv")
setwd("Y:\\Natasha\\Ontology issue with BW\\Figures")

library(plyr)
countDataPoints<-function(dataset, depVariable){
	print(sum(is.finite(dataset[ , depVariable])))
}

Index = ddply(.data=df1, .variables=c("Genotype", "Gender"), .fun=countDataPoints, depVariable="Lean.Mass")		


png("Akt2_LM_Male.png")
scatterplot(data=df1, Lean.Mass~Weight|Genotype, subset= Dlg4$Gender=="Male", grid=FALSE, legend.plot=FALSE, cex.axis=1.4, cex.lab=1.6, lwd=3, smooth=FALSE, xlab="Body weight (g)", ylab="Lean mass (g)")
legend(15,28, # places a legend at the appropriate place 
		c("Wildtype","Akt2"), # puts text in the legend
		
		lty=c(1,1), # gives the legend appropriate symbols (lines)
		
		,col=c("black","red"),bty="n", lwd=3, cex=1.6)
dev.off()

png("Akt2_LM_Female.png")
scatterplot(data=df1, Lean.Mass~Weight|Genotype, subset= Dlg4$Gender=="Female", grid=FALSE, legend.plot=FALSE, cex.axis=1.4, cex.lab=1.6, lwd=3, smooth=FALSE, xlab="Body weight (g)", ylab="Lean mass (g)")
legend(17,26, # places a legend at the appropriate place 
		c("Wildtype","Akt2"), # puts text in the legend
		
		lty=c(1,1), # gives the legend appropriate symbols (lines)
		
		,col=c("black","red"),bty="n", lwd=3, cex=1.6)
dev.off()


library(phenStat)
PhenObject=PhenList(df1, testGenotype="Akt2/Akt2", dataset.colname.sex="Gender", dataset.clean=TRUE,dataset.colname.batch="Assay.Date", dataset.colname.genotype="Genotype", dataset.colname.weight="Weight", dataset.values.male="Male", 		dataset.values.female="Female") 
Modelfeatures=testDataset(PhenObject, depVariable="Lean.Mass", equation="withWeight", transformValues=FALSE)  
summaryOutput(Modelfeatures)
Modelfeatures=testDataset(PhenObject, depVariable="Lean.Mass", equation="withoutWeight", transformValues=FALSE)  
summaryOutput(Modelfeatures)


######################Figure 4
# Question 2: How often weight included in the models  (Figure 4)?
#PhenStat completes a model optimisation process.  If weight is not significant in explaining the variation (F test, p<0.05) then weight is not included in the final model.
FinalDf=read.csv("MERGED_withANDwithoutWeight.csv")

WEIGHTinclusion<-function(dataset){
	numberDatasets=sum(is.finite(dataset[ , "GENOTYPE_CONTRIBUTION.y"]))
	numberIncluded= sum(dataset[ , "WEIGHT_PVALUE.y"]<=0.05, na.rm = TRUE)
	PercentIncluded=(numberIncluded/numberDatasets)*100
	output=c(numberDatasets, numberIncluded,PercentIncluded )
	names(output)=c("numberDatasets", "numberIncluded","PercentIncluded")
	return(output)
}
library(plyr)
Index = ddply(.data=FinalDf, .variables=c("PARAMETER.y"), .fun=WEIGHTinclusion)		

pdf("Figure4_RoleOfWeight.pdf")
hist(Index$PercentIncluded, main ="", xlab="Modelling that included weight (%)", ylab="Number of variables", cex.lab=1.4)
dev.off()

#######################Figure 5
#Load statistical analysis output from data being processed by  A1 (equation="withoutWeight") and then A2 (equation="withWeight").
#The columns are those contains in the vector output from PhenStat version 2.0.1. The descriptors of the columns are described in the associated PhenStat User Guide. 
#columns dervied from A1 are appended with .x and the columns dervied from A2 are appended with .y

FinalDf=read.csv("MERGED_withANDwithoutWeight.csv")

#Question 1: How often does including weight change the number of significant calls (Figure 5)?
#This output was used to construct the Venn diagram in figure 5

ConsistencyCalls<-function(df, Sig_withoutWeight, Sig_withWeight){
	SigWithoutWeight=df[ ,Sig_withoutWeight]<=0.0001
	SigWithWeight=df[ ,Sig_withWeight]<=0.0001
	if(SigWithoutWeight==TRUE && SigWithWeight==TRUE){
		CallConsistency="Both Significant"
	}else if (SigWithoutWeight==FALSE && SigWithWeight==TRUE){
		CallConsistency="Significant withWeight Only"
	}else if (SigWithoutWeight==TRUE && SigWithWeight==FALSE){
		CallConsistency="Significant withoutWeight Only"
	}else{
		CallConsistency="no call"	
	}
	return(CallConsistency)
}

library(plyr)

Index1= ddply(.data=FinalDf, .variables=c("id"), .fun=ConsistencyCalls, Sig_withoutWeight="GENOTYPE_CONTRIBUTION.x", Sig_withWeight="GENOTYPE_CONTRIBUTION.y")		
head(Index1)
table(Index1$V1)


