/*
    Processor chains for hyperconnected logistics
    Copyright (C) 2018-2019 Laboratoire d'informatique formelle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ca.uqac.lif.cep.supplychain.test;

import static org.junit.Assert.*;

import ca.uqac.lif.cep.Connector;
import ca.uqac.lif.cep.Pushable;
import ca.uqac.lif.cep.supplychain.Constants;
import ca.uqac.lif.cep.supplychain.MaxReroutings;
import ca.uqac.lif.cep.tmf.QueueSink;
import ca.uqac.lif.cep.tuples.FixedTupleBuilder;
import java.util.Queue;
import org.junit.Test;

public class MaxReroutingsTest
{
  FixedTupleBuilder m_builder = new FixedTupleBuilder(Constants.S_TIMESTAMP,
      Constants.S_SHIPMENT_ID, Constants.S_TYPE,
      Constants.S_LOCATION_X, Constants.S_LOCATION_Y,
      Constants.S_DESTINATION_X, Constants.S_DESTINATION_Y);
  
  @Test
  public void test1()
  {
    MaxReroutings mr = new MaxReroutings(1);
    Pushable p = mr.getPushableInput();
    QueueSink sink = new QueueSink();
    Connector.connect(mr, sink);
    Queue<Object> q = sink.getQueue();
    p.push(m_builder.createTuple(1, 0, Constants.C_PICKUP, 0, 0, 100, 100));
    assertFalse(q.isEmpty());
    p.push(m_builder.createTuple(2, 0, Constants.C_DELIVERY, 10, 10, 100, 100));
    assertFalse(q.isEmpty());
  }
  
  @Test
  public void testCounter1()
  {
    MaxReroutings mr = new MaxReroutings(1);
    MaxReroutings.ReroutingCounter rc = mr.newReroutingCounter();
    Pushable p = rc.getPushableInput();
    QueueSink sink = new QueueSink();
    Connector.connect(rc, sink);
    Queue<Object> q = sink.getQueue();
    p.push(m_builder.createTuple(1, 0, Constants.C_PICKUP, 0, 0, 100, 100));
    assertFalse(q.isEmpty());
    p.push(m_builder.createTuple(2, 0, Constants.C_DELIVERY, 10, 10, 100, 100));
    assertFalse(q.isEmpty());
  }
}
