/*
    Processor chains for hyperconnected logistics
    Copyright (C) 2018-2019 Laboratoire d'informatique formelle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ca.uqac.lif.cep.supplychain.examples;

import ca.uqac.lif.cep.io.Print;
import ca.uqac.lif.cep.io.ReadLines;
import ca.uqac.lif.cep.supplychain.ParcelLifecycle;
import ca.uqac.lif.cep.tmf.Fork;
import ca.uqac.lif.cep.tmf.Pump;
import ca.uqac.lif.cep.tuples.TupleFeeder;

import static ca.uqac.lif.cep.Connector.connect;
import static ca.uqac.lif.cep.Connector.TOP;
import static ca.uqac.lif.cep.Connector.INPUT;
import static ca.uqac.lif.cep.Connector.BOTTOM;
import static ca.uqac.lif.cep.Connector.OUTPUT;

public class ParcelLifecycleExample
{
	public static void main(String[] args)
	{
		String filename = "data/example_lifecycle_1.csv";
		ReadLines reader = new ReadLines(ParcelLifecycleExample.class.getResourceAsStream(filename));
		TupleFeeder tuples = new TupleFeeder();
		connect(reader, tuples);
		Pump pump = new Pump();
		connect(tuples, pump);
		Fork f = new Fork(2);
		connect(pump, f);
		Print print_1 = new Print().setSeparator("\n");
		connect(f, TOP, print_1, INPUT);
		ParcelLifecycle pl = new ParcelLifecycle();
		connect(f, BOTTOM, pl, INPUT);
		Print print_2 = new Print().setSeparator("\n");
		connect(pl, OUTPUT, print_2, INPUT);
		pump.turn(5);
	}
}
