/*
    Processor chains for hyperconnected logistics
    Copyright (C) 2018-2019 Laboratoire d'informatique formelle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ca.uqac.lif.cep.supplychain;

import ca.uqac.lif.cep.functions.Constant;
import ca.uqac.lif.cep.functions.FunctionTree;
import ca.uqac.lif.cep.tuples.FetchAttribute;
import ca.uqac.lif.cep.util.Numbers;

import static ca.uqac.lif.cep.supplychain.Constants.S_DESTINATION_X;
import static ca.uqac.lif.cep.supplychain.Constants.S_DESTINATION_Y;
import static ca.uqac.lif.cep.supplychain.Constants.S_LOCATION_X;
import static ca.uqac.lif.cep.supplychain.Constants.S_LOCATION_Y;

/**
 * Function which, in a given event, computes the (Euclidean) distance between
 * a parcel and its destination.
 */
public class DistanceToTarget extends FunctionTree
{
  /**
   * A static reference to the constant "two"
   */
  protected static final transient Constant TWO = new Constant(2);
  
  /**
   * A reference to a single instance of the functino
   */
  public static final transient DistanceToTarget instance = new DistanceToTarget();
  
  /**
   * Creates a new instance of the function
   */
  protected DistanceToTarget()
  {
    super(Numbers.addition,
        new FunctionTree(Numbers.power, 
            new FunctionTree(Numbers.subtraction,
                new FunctionTree(Numbers.numberCast, new FetchAttribute(S_LOCATION_X)), 
                new FunctionTree(Numbers.numberCast, new FetchAttribute(S_DESTINATION_X))), TWO),
        new FunctionTree(Numbers.power, 
            new FunctionTree(Numbers.subtraction,
                new FunctionTree(Numbers.numberCast, new FetchAttribute(S_LOCATION_Y)),
                new FunctionTree(Numbers.numberCast, new FetchAttribute(S_DESTINATION_Y))), TWO)
        );
  }
  
  @Override
  public DistanceToTarget duplicate(boolean with_state)
  {
    return this;
  }
}
