/*
    Processor chains for hyperconnected logistics
    Copyright (C) 2018-2019 Laboratoire d'informatique formelle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ca.uqac.lif.cep.supplychain;

import ca.uqac.lif.cep.functions.Constant;
import ca.uqac.lif.cep.ltl.Troolean;

/**
 * Singleton class that defines constants that are reused throughout all the
 * examples. This is to avoid hard-coding the same strings all over the
 * code fragments.
 */
public class Constants
{
	/**
	 * The string used in the input stream to designate a pick-up event
	 */
	public static final String S_PICKUP = "PICK_UP";
	
	/**
	 * The string used in the input stream to designate a delivery event
	 */
	public static final String S_DELIVERY = "DELIVERY";
	
	/**
	 * The string used in the input stream to designate the shipment ID attribute
	 */
	public static final String S_SHIPMENT_ID = "shipment_id";
	
	/**
   * The string used in the input stream to designate the timestamp
   */
  public static final String S_TIMESTAMP = "timestamp";
	
	/**
	 * The string used in the input stream to designate the "location x" attribute
	 */
	public static final String S_LOCATION_X = "location_x";
	
	/**
	 * The string used in the input stream to designate the "location y" attribute
	 */
	public static final String S_LOCATION_Y = "location_y";
	
	/**
   * The string used in the input stream to designate the
   * "destination x" attribute
   */
  public static final String S_DESTINATION_X = "destination_x";
  
  /**
   * The string used in the input stream to designate the
   * "destination y" attribute
   */
  public static final String S_DESTINATION_Y = "destination_y";
	
	/**
	 * The string used in the input stream to designate the "event type" attribute
	 */
	public static final String S_TYPE = "type";
	
	/**
	 * A constant object designating the pick-up string
	 */
	public static final Constant C_PICKUP = new Constant(S_PICKUP);
	
	/**
	 * A constant object designating the delivery string
	 */
	public static final Constant C_DELIVERY = new Constant(S_DELIVERY);
	
	/**
	 * A constant object designating the Troolean "true"
	 */
	public static final transient Constant TRUE = new Constant(Troolean.Value.TRUE);
	
	/**
	 * A constant object designating the Troolean "false"
	 */
	public static final transient Constant INCONCLUSIVE = new Constant(Troolean.Value.INCONCLUSIVE);
	
	/**
	 * A constant object designating the Troolean "false"
	 */
	public static final transient Constant FALSE = new Constant(Troolean.Value.FALSE);
	
	/**
	 * A constant object designating the value 0
	 */
	public static final transient Constant ZERO = new Constant(0);
	
	/**
   * A constant object designating the value 1
   */
  public static final transient Constant ONE = new Constant(1);
}
