setwd("P:/JK Australia Manuscripts")
EUCBIOMASS<-read.csv("EUC_BIOMASS.csv",sep=",", header=TRUE)
names(EUCBIOMASS)
str(EUCBIOMASS)
EUCBIOMASS$H2O<-factor(EUCBIOMASS$H2O,levels=c("High water","Low water"))
windows(width=10, height=5) #, pointsize=18)
par(mfrow=c(1,2), omi=c(.5, 0.75, 0.75, .5)) 
#(bottom, left, top, right)
par(mar=c(2, 2, 1.75, 1))
 
par(xaxs="i",yaxs="i")
par(las=1)
#myticks<-c(0.0,1.0,2.0,3.0,4.0)
with(EUCBIOMASS,plot(g1[ST=="PILAD"]~H[ST=="PILAD"],xlim=c(0,4),ylim=c(0,6),col="blue",pch=1,xlab="",ylab="",cex.axis=1.25))
with(EUCBIOMASS,points(g1[ST=="PILAND"]~H[ST=="PILAND"],col="blue",pch=16,cex=1.25))
with(EUCBIOMASS,points(g1[ST=="PILEND"]~H[ST=="PILEND"],col="red",pch=16,cex=1.25))
with(EUCBIOMASS,points(g1[ST=="PILED"]~H[ST=="PILED"],col="red",pch=1,cex=1.25))
title(main="Eucalyptus pilularis",font.main=4,cex.main=1.25)
#axis(1,at=c(0.0,1.0,2.0,3.0,4.0,by=0.5),cex=1.25)
A<-with(EUCBIOMASS,lm(g1[Species=="PIL"]~H[Species=="PIL"]))
summary(A)
abline(A,lwd=2)
text(3.25,5.5, expression(italic(R)^2==0.137),font=4)
text(3.25,5,expression(p<0.006))
with(EUCBIOMASS,legend("topleft", legend=c(expression(aC[a]-W,aC[a]-D,eC[a]-W,eC[a]-D)),bty="n",pch=c(16,1,16,1),pt.cex=1.25,col=c("blue","blue","red","red")))
mtext(side = 1, text =expression(bold("Height (m)")), line = 2.5,font=2, cex=1.25)
#mtext(side = 1, text =expression(bold((m))), line=3.5,
 #     font=2,cex=1)
par(las=3)
mtext(side = 2, text =expression(bold(g[1])), line = 2.5,font=2, cex=1.25)
par(las=1)
#(bottom, left, top, right)
par(mar=c(2, 1, 1.75, 2))
with(EUCBIOMASS,plot(g1[ST=="POPAD"]~H[ST=="POPAD"],xlim=c(0,2),yaxt="n",ylim=c(0,12),col="blue",pch=1,xlab="",ylab="",cex.axis=1.25))
with(EUCBIOMASS,points(g1[ST=="POPAND"]~H[ST=="POPAND"],col="blue",pch=16,cex=1.25))
with(EUCBIOMASS,points(g1[ST=="POPEND"]~H[ST=="POPEND"],col="red",pch=16,cex=1.25))
with(EUCBIOMASS,points(g1[ST=="POPED"]~H[ST=="POPED"],col="red",pch=1,cex=1.25))
title(main="Eucalyptus populnea",font.main=4,cex.main=1.25)
B<-with(EUCBIOMASS,lm(g1[Species=="POP"]~H[Species=="POP"]))
summary(B)
abline(B,lty=1,lwd=2)
text(1.5,11, expression(italic(R)^2==0.251),font=4)
text(1.5,10,expression(p<0.0002))
par(las=3)
mtexti(text =expression(bold(g[1])),font=2,cex=1.25, 4)
par(las=1)
axis(4,labels=TRUE,cex.axis=1.25)
mtext(side = 1, text =expression(bold("Height (m)")), line = 2.5,font=2, cex=1.25)
#mtext(side = 1, text =expression(bold((m))), line=3.5,
    #  font=2,cex=1)



